/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DefaultThreadSafeCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private final Function<CursorContext, StoreCursors> storeCursorsFactory;
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private boolean applyAccessModeToTxState;

    public DefaultThreadSafeCursors(StorageReader storageReader, Config config, Function<CursorContext, StoreCursors> storeCursorsFactory, StorageEngineIndexingBehaviour indexingBehaviour, boolean applyAccessModeToTxState) {
        super(new ConcurrentLinkedQueue<DefaultCursors.CloseableStacktrace>(), config);
        this.storageReader = storageReader;
        this.storeCursorsFactory = storeCursorsFactory;
        this.indexingBehaviour = indexingBehaviour;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    public DefaultNodeCursor allocateNodeCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultNodeCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocateNodeCursor(cursorContext, storeCursors), this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessNodeCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocateNodeCursor(cursorContext, storeCursors)));
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultRelationshipScanCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors), this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public FullAccessRelationshipScanCursor allocateFullAccessRelationshipScanCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessRelationshipScanCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors)));
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultRelationshipTraversalCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, storeCursors), this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public DefaultRelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessRelationshipTraversalCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, storeCursors)));
    }

    public DefaultPropertyCursor allocatePropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultPropertyCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.storageReader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker), this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public PropertyCursor allocateFullAccessPropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessPropertyCursor(defaultPropertyCursor -> {
            defaultPropertyCursor.release();
            storeCursors.close();
        }, this.storageReader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker)));
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultNodeValueIndexCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public NodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.trace(new FullAccessNodeValueIndexCursor(DefaultNodeValueIndexCursor::release));
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultNodeLabelIndexCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public NodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(CursorContext cursorContext) {
        return this.trace(new FullAccessNodeLabelIndexCursor(DefaultNodeLabelIndexCursor::release));
    }

    public RelationshipValueIndexCursor allocateRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultRelationshipValueIndexCursor(cursor -> {
            cursor.release();
            storeCursors.close();
        }, this.allocateRelationshipScanCursor(cursorContext, memoryTracker), this.newInternalCursors(storeCursors, cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public RelationshipValueIndexCursor allocateFullAccessRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.trace(new FullAccessRelationshipValueIndexCursor(DefaultRelationshipValueIndexCursor::release));
    }

    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.indexingBehaviour.useNodeIdsInRelationshipTokenIndex()) {
            return this.trace(new DefaultNodeBasedRelationshipTypeIndexCursor(DefaultNodeBasedRelationshipTypeIndexCursor::release, this.allocateNodeCursor(cursorContext, memoryTracker), this.allocateRelationshipTraversalCursor(cursorContext, memoryTracker)));
        }
        return this.trace(new DefaultRelationshipBasedRelationshipTypeIndexCursor(DefaultRelationshipBasedRelationshipTypeIndexCursor::release, this.allocateRelationshipScanCursor(cursorContext, memoryTracker), this.applyAccessModeToTxState));
    }

    public RelationshipTypeIndexCursor allocateFullAccessRelationshipTypeIndexCursor(CursorContext cursorContext) {
        if (this.indexingBehaviour.useNodeIdsInRelationshipTokenIndex()) {
            return this.trace(new DefaultNodeBasedRelationshipTypeIndexCursor(DefaultNodeBasedRelationshipTypeIndexCursor::release, this.allocateFullAccessNodeCursor(cursorContext), this.allocateFullAccessRelationshipTraversalCursor(cursorContext)));
        }
        return this.trace(new FullAccessRelationshipBasedRelationshipTypeIndexCursor(DefaultRelationshipBasedRelationshipTypeIndexCursor::release, this.allocateFullAccessRelationshipScanCursor(cursorContext)));
    }

    public void close() {
        this.assertClosed();
        this.storageReader.close();
    }

    private InternalCursorFactory newInternalCursors(StoreCursors storeCursors, CursorContext cursorContext, MemoryTracker memoryTracker) {
        return new InternalCursorFactory(this.storageReader, storeCursors, cursorContext, memoryTracker, this.applyAccessModeToTxState);
    }
}

