/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StandardConstraintRuleAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
extends ConstraintSemantics {
    public static final String ERROR_MESSAGE_EXISTS = "Property existence constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_KEY_SUFFIX = "Key constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_TYPE = "Property type constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_ENDPOINT = "Relationship endpoint label constraint requires Neo4j Enterprise Edition";
    protected final StandardConstraintRuleAccessor accessor = new StandardConstraintRuleAccessor();

    public StandardConstraintSemantics() {
        this(1);
    }

    protected StandardConstraintSemantics(int priority) {
        super(priority);
    }

    public String getName() {
        return "standardConstraints";
    }

    @Override
    public void assertKeyConstraintAllowed(SchemaDescriptor descriptor) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed(descriptor);
    }

    @Override
    public void validateNodeKeyConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateRelKeyConstraint(RelationshipTypeIndexCursor allRelationships, RelationshipScanCursor relCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateNodePropertyExistenceConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, isDependent);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, isDependent);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(RelationshipTypeIndexCursor allRelationships, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, isDependent);
    }

    public ConstraintDescriptor readConstraint(ConstraintDescriptor constraint) {
        return switch (constraint.type()) {
            case ConstraintType.EXISTS -> this.readNonStandardConstraint(constraint, ERROR_MESSAGE_EXISTS);
            case ConstraintType.UNIQUE_EXISTS -> this.readNonStandardConstraint(constraint, StandardConstraintSemantics.keyConstraintErrorMessage(constraint.schema()));
            default -> constraint;
        };
    }

    protected ConstraintDescriptor readNonStandardConstraint(ConstraintDescriptor constraint, String errorMessage) {
        throw new IllegalStateException(errorMessage);
    }

    private static CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(SchemaDescriptor descriptor, boolean isDependent) {
        return new CreateConstraintFailureException((ConstraintDescriptor)ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)descriptor, (boolean)isDependent), ERROR_MESSAGE_EXISTS);
    }

    private static CreateConstraintFailureException propertyTypeConstraintsNotAllowed(TypeConstraintDescriptor descriptor) {
        return new CreateConstraintFailureException((ConstraintDescriptor)descriptor, ERROR_MESSAGE_TYPE);
    }

    private static CreateConstraintFailureException relationshipEndpointLabelConstraintsNotAllowed(RelationshipEndpointConstraintDescriptor descriptor) {
        return new CreateConstraintFailureException((ConstraintDescriptor)descriptor, ERROR_MESSAGE_ENDPOINT);
    }

    private static String keyConstraintErrorMessage(SchemaDescriptor descriptor) {
        return (descriptor.entityType() == EntityType.NODE ? "Node " : "Relationship ") + ERROR_MESSAGE_KEY_SUFFIX;
    }

    private static CreateConstraintFailureException keyConstraintsNotAllowed(SchemaDescriptor descriptor) {
        return new CreateConstraintFailureException((ConstraintDescriptor)ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)descriptor), StandardConstraintSemantics.keyConstraintErrorMessage(descriptor));
    }

    public ConstraintDescriptor createUniquenessConstraintRule(long ruleId, UniquenessConstraintDescriptor descriptor, long indexId) {
        return this.accessor.createUniquenessConstraintRule(ruleId, descriptor, indexId);
    }

    public ConstraintDescriptor createKeyConstraintRule(long ruleId, KeyConstraintDescriptor descriptor, long indexId) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed(descriptor.schema());
    }

    public ConstraintDescriptor createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed(descriptor.schema(), descriptor.graphTypeDependence() == GraphTypeDependence.DEPENDENT);
    }

    public ConstraintDescriptor createPropertyTypeConstraint(long ruleId, TypeConstraintDescriptor descriptor) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor);
    }

    public ConstraintDescriptor createRelationshipEndpointConstraint(long ruleId, RelationshipEndpointConstraintDescriptor descriptor) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.relationshipEndpointLabelConstraintsNotAllowed(descriptor);
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StorageReader storageReader, Read read, CursorFactory cursorFactory, ReadableTransactionState state, TxStateVisitor visitor, CursorContext cursorContext, MemoryTracker memoryTracker) {
        return visitor;
    }

    @Override
    public void validateNodePropertyExistenceConstraint(NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, isDependent);
    }

    @Override
    public void validateNodeKeyConstraint(NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateRelKeyConstraint(RelationshipScanCursor relCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateNodePropertyTypeConstraint(NodeCursor nodeCursor, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor);
    }

    @Override
    public void validateNodePropertyTypeConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor);
    }

    @Override
    public void validateRelationshipPropertyTypeConstraint(RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor);
    }

    @Override
    public void validateRelationshipPropertyTypeConstraint(RelationshipTypeIndexCursor allRelationships, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor);
    }
}

