/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ExecutionContextProcedureKernelTransaction
implements KernelTransaction,
TxStateHolder {
    private final KernelTransaction ktx;
    private final ExecutionContext ctx;
    private final long transactionSequenceNumberWhenCreated;

    public ExecutionContextProcedureKernelTransaction(KernelTransaction ktx, ExecutionContext ctx) {
        this.ktx = ktx;
        this.transactionSequenceNumberWhenCreated = ktx.getTransactionSequenceNumber();
        this.ctx = ctx;
    }

    public ExecutionContext executionContext() {
        return this.ctx;
    }

    public long commit(KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor) throws TransactionFailureException {
        throw new UnsupportedOperationException("Committing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void rollback() {
        throw new UnsupportedOperationException("Rolling back ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public Read dataRead() {
        return this.ctx.dataRead();
    }

    public Write dataWrite() throws InvalidTransactionTypeKernelException {
        throw ExecutionContextProcedureKernelTransaction.failure("dataWrite");
    }

    public TokenRead tokenRead() {
        return this.ctx.tokenRead();
    }

    public TokenWrite tokenWrite() {
        throw ExecutionContextProcedureKernelTransaction.failure("tokenWrite");
    }

    public Token token() {
        throw ExecutionContextProcedureKernelTransaction.failure("token");
    }

    public SchemaRead schemaRead() {
        return this.ctx.schemaRead();
    }

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
        throw ExecutionContextProcedureKernelTransaction.failure("schemaWrite");
    }

    public Upgrade upgrade() {
        throw ExecutionContextProcedureKernelTransaction.failure("upgrade");
    }

    public Locks locks() {
        return this.ctx.locks();
    }

    public CursorFactory cursors() {
        return this.ctx.cursors();
    }

    public Procedures procedures() {
        return this.ctx.procedures();
    }

    public ExecutionStatistics executionStatistics() {
        throw ExecutionContextProcedureKernelTransaction.failure("executionStatistics");
    }

    public long closeTransaction() throws TransactionFailureException {
        throw new UnsupportedOperationException("Closing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void close() throws TransactionFailureException {
        throw new UnsupportedOperationException("Closing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public boolean isOpen() {
        return this.ktx.isOpen() && !this.ktx.isTerminated() && this.isOriginalTx();
    }

    public boolean isClosing() {
        return this.ktx.isClosing() && this.isOriginalTx();
    }

    public boolean isCommitting() {
        return this.ktx.isCommitting() && this.isOriginalTx();
    }

    public boolean isRollingback() {
        return this.ktx.isRollingback() && this.isOriginalTx();
    }

    public Optional<TerminationMark> getTerminationMark() {
        Optional mark = this.ktx.getTerminationMark();
        this.assertIsOriginalTx();
        return mark;
    }

    public void releaseStorageEngineResources() {
        throw ExecutionContextProcedureKernelTransaction.failure("releaseStorageEngineResources");
    }

    public boolean isTerminated() {
        return this.ktx.isTerminated() && this.isOriginalTx();
    }

    public void markForTermination(Status reason) {
        throw ExecutionContextProcedureKernelTransaction.failure("markForTermination");
    }

    public void setMetaData(Map<String, Object> data) {
        throw ExecutionContextProcedureKernelTransaction.failure("setMetaData");
    }

    public Map<String, Object> getMetaData() {
        throw ExecutionContextProcedureKernelTransaction.failure("getMetaData");
    }

    public void assertOpen() {
        this.ktx.assertOpen();
        this.assertIsOriginalTx();
    }

    public void setStatusDetails(String details) {
        this.assertIsOriginalTx();
        this.ktx.setStatusDetails(details);
    }

    public String statusDetails() {
        String details = this.ktx.statusDetails();
        this.assertIsOriginalTx();
        return details;
    }

    public Statement acquireStatement() {
        throw ExecutionContextProcedureKernelTransaction.failure("acquireStatement");
    }

    public int aquireStatementCounter() {
        throw ExecutionContextProcedureKernelTransaction.failure("aquireStatementCounter");
    }

    public ResourceMonitor resourceMonitor() {
        return this.ctx;
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) throws KernelException {
        throw ExecutionContextProcedureKernelTransaction.failure("indexUniqueCreate");
    }

    public SecurityContext securityContext() {
        return this.ctx.securityContext();
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.ctx.securityAuthorizationHandler();
    }

    public ClientConnectionInfo clientInfo() {
        throw ExecutionContextProcedureKernelTransaction.failure("clientInfo");
    }

    public AuthSubject subjectOrAnonymous() {
        throw ExecutionContextProcedureKernelTransaction.failure("subjectOrAnonymous");
    }

    public void bindToUserTransaction(InternalTransaction internalTransaction) {
        throw ExecutionContextProcedureKernelTransaction.failure("bindToUserTransaction");
    }

    public InternalTransaction internalTransaction() {
        return new ExecutionContextProcedureTransaction(this);
    }

    public long startTime() {
        throw ExecutionContextProcedureKernelTransaction.failure("startTime");
    }

    public long startTimeNanos() {
        throw ExecutionContextProcedureKernelTransaction.failure("startTimeNanos");
    }

    public TransactionTimeout timeout() {
        throw ExecutionContextProcedureKernelTransaction.failure("timeout");
    }

    public KernelTransaction.Type transactionType() {
        throw ExecutionContextProcedureKernelTransaction.failure("transactionType");
    }

    public long getTransactionId() {
        long id = this.ktx.getTransactionId();
        this.assertIsOriginalTx();
        return id;
    }

    public long getTransactionSequenceNumber() {
        long n = this.ktx.getTransactionSequenceNumber();
        this.assertIsOriginalTx();
        return n;
    }

    public long getCommitTime() {
        throw ExecutionContextProcedureKernelTransaction.failure("getCommitTime");
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        throw ExecutionContextProcedureKernelTransaction.failure("overrideWith");
    }

    public ClockContext clocks() {
        throw ExecutionContextProcedureKernelTransaction.failure("clocks");
    }

    public NodeCursor ambientNodeCursor() {
        throw ExecutionContextProcedureKernelTransaction.failure("ambientNodeCursor");
    }

    public RelationshipScanCursor ambientRelationshipCursor() {
        throw ExecutionContextProcedureKernelTransaction.failure("ambientRelationshipCursor");
    }

    public PropertyCursor ambientPropertyCursor() {
        throw ExecutionContextProcedureKernelTransaction.failure("ambientPropertyCursor");
    }

    public boolean isSchemaTransaction() {
        return false;
    }

    public CursorContext cursorContext() {
        return this.ctx.cursorContext();
    }

    public ExecutionContext createExecutionContext() {
        throw ExecutionContextProcedureKernelTransaction.failure("createExecutionContext");
    }

    public MemoryTracker createExecutionContextMemoryTracker() {
        throw ExecutionContextProcedureKernelTransaction.failure("createExecutionContextMemoryTracker");
    }

    public QueryContext queryContext() {
        return this.ctx.queryContext();
    }

    public StoreCursors storeCursors() {
        throw ExecutionContextProcedureKernelTransaction.failure("storeCursors");
    }

    public MemoryTracker memoryTracker() {
        return this.ctx.memoryTracker();
    }

    public UUID getDatabaseId() {
        UUID uuid = this.ktx.getDatabaseId();
        this.assertIsOriginalTx();
        return uuid;
    }

    public String getDatabaseName() {
        String dbName = this.ktx.getDatabaseName();
        this.assertIsOriginalTx();
        return dbName;
    }

    public InnerTransactionHandler getInnerTransactionHandler() {
        throw ExecutionContextProcedureKernelTransaction.failure("getInnerTransactionHandler");
    }

    private boolean isOriginalTx() {
        return this.transactionSequenceNumberWhenCreated == this.ktx.getTransactionSequenceNumber();
    }

    private void assertIsOriginalTx() {
        if (!this.isOriginalTx()) {
            throw new IllegalStateException("Execution context used after transaction close");
        }
    }

    static UnsupportedOperationException failure(String op) {
        return new UnsupportedOperationException("`transaction." + op + "' is not supported in procedures when called from parallel runtime. Please retry using another runtime.");
    }

    public TransactionState txState() {
        throw new UnsupportedOperationException("Accessing transaction state is not allowed during parallel execution");
    }

    public boolean hasTxStateWithChanges() {
        return false;
    }
}

