/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.List;
import org.neo4j.kernel.impl.api.CommandCommitListener;
import org.neo4j.storageengine.api.CommandBatch;

public class CommandCommitListeners {
    public static final CommandCommitListeners NO_LISTENERS = new CommandCommitListeners(new CommandCommitListener[0]);
    private final List<CommandCommitListener> listeners;

    public CommandCommitListeners(CommandCommitListener ... listeners) {
        this.listeners = List.of(listeners);
    }

    public void registerFailure(CommandBatch commandBatch, Exception exception) {
        for (CommandCommitListener listener : this.listeners) {
            listener.onCommandBatchCommitFailure(commandBatch, exception);
        }
    }

    public void registerSuccess(CommandBatch commandBatch, long lastCommittedTx) {
        for (CommandCommitListener listener : this.listeners) {
            listener.onCommandBatchCommitSuccess(commandBatch, lastCommittedTx);
        }
    }
}

