/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.migration;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.api.format.MultiVersionedIndexesCompatibility;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class TokenIndexMigrator
extends AbstractStoreMigrationParticipant {
    private static final String LEGACY_LABEL_INDEX_STORE = "neostore.labelscanstore.db";
    private static final String LEGACY_RELATIONSHIP_TYPE_INDEX_STORE = "neostore.relationshiptypescanstore.db";
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseLayout layout;
    private final Function<SchemaRule, Path> storeFileProvider;
    private boolean deleteRelationshipTokenIndex;
    private boolean moveFiles;
    private final CursorContextFactory contextFactory;
    private boolean deleteAllIndexes;

    public TokenIndexMigrator(String name, FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, DatabaseLayout layout, Function<SchemaRule, Path> storeFileProvider, CursorContextFactory contextFactory) {
        super(name);
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.pageCacheTracer = pageCacheTracer;
        this.storageEngineFactory = storageEngineFactory;
        this.layout = layout;
        this.storeFileProvider = storeFileProvider;
        this.contextFactory = contextFactory;
    }

    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressListener progressListener, StoreVersion fromVersion, StoreVersion toVersion, IndexImporterFactory indexImporterFactory, LogTailMetadata tailMetadata) {
        this.deleteAllIndexes = this.differentMultiVersionCapabilities(toVersion, fromVersion);
        this.deleteRelationshipTokenIndex = !fromVersion.hasCompatibleCapabilities(toVersion, CapabilityType.FORMAT);
        this.moveFiles = this.scanStoreExists(directoryLayout, LEGACY_LABEL_INDEX_STORE) || this.scanStoreExists(directoryLayout, LEGACY_RELATIONSHIP_TYPE_INDEX_STORE);
    }

    private boolean differentMultiVersionCapabilities(StoreVersion toVersion, StoreVersion fromVersion) {
        return toVersion.hasCapability((Capability)MultiVersionedIndexesCompatibility.MULTI_VERSION_INDEXES) ^ fromVersion.hasCapability((Capability)MultiVersionedIndexesCompatibility.MULTI_VERSION_INDEXES);
    }

    private boolean scanStoreExists(DatabaseLayout directoryLayout, String fileName) {
        return this.fileSystem.fileExists(directoryLayout.file(fileName));
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, StoreVersion versionToUpgradeFrom, StoreVersion versionToMigrateTo) throws IOException {
        if (this.moveFiles) {
            this.moveTokenIndexes(directoryLayout);
        }
        if (this.deleteAllIndexes) {
            this.deleteTokenIndex(directoryLayout, any -> true);
        } else if (this.deleteRelationshipTokenIndex) {
            this.deleteTokenIndex(directoryLayout, rule -> rule.schema().entityType() == EntityType.RELATIONSHIP);
        }
    }

    public void cleanup(DatabaseLayout migrationLayout) {
    }

    private void moveTokenIndexes(DatabaseLayout databaseLayout) throws IOException {
        for (SchemaRule schemaRule : this.storageEngineFactory.loadSchemaRules(this.fileSystem, this.pageCache, this.pageCacheTracer, Config.defaults(), databaseLayout, false, r -> r, this.contextFactory)) {
            if (!schemaRule.schema().isSchemaDescriptorType(AnyTokenSchemaDescriptor.class)) continue;
            if (schemaRule.schema().entityType() == EntityType.NODE) {
                this.moveFile(schemaRule, LEGACY_LABEL_INDEX_STORE);
                continue;
            }
            this.moveFile(schemaRule, LEGACY_RELATIONSHIP_TYPE_INDEX_STORE);
        }
    }

    private void moveFile(SchemaRule schemaRule, String legacyFileName) throws IOException {
        if (this.scanStoreExists(this.layout, legacyFileName)) {
            Path destination = this.storeFileProvider.apply(schemaRule);
            try {
                this.fileSystem.mkdirs(destination.getParent());
                this.fileSystem.renameFile(this.layout.file(legacyFileName), destination, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new IOException("Failed to move LOOKUP index files to index directory during migration", e);
            }
        }
    }

    private void deleteTokenIndex(DatabaseLayout databaseLayout, Predicate<SchemaRule> tokenIndexFilter) throws IOException {
        for (SchemaRule schemaRule : this.storageEngineFactory.loadSchemaRules(this.fileSystem, this.pageCache, this.pageCacheTracer, Config.defaults(), databaseLayout, false, r -> r, this.contextFactory)) {
            if (!schemaRule.schema().isSchemaDescriptorType(AnyTokenSchemaDescriptor.class) || !tokenIndexFilter.test(schemaRule)) continue;
            Path indexFile = this.storeFileProvider.apply(schemaRule);
            try {
                this.fileSystem.deleteFile(indexFile);
            }
            catch (IOException e) {
                throw new IOException("Failed to remove a relationship LOOKUP index file during migration", e);
            }
        }
    }
}

