/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.InternalLog;

public class JvmChecker {
    public static final Pattern SUPPORTED_JAVA_NAME_PATTERN = Pattern.compile("(Java HotSpot\\(TM\\)|OpenJDK) (64-Bit Server|Server) VM");
    public static final String NEO4J_JAVA_WARNING_MESSAGE = "Please use Java(TM) 17 or Java(TM) 21 to run Neo4j.";
    private static final IntSet SUPPORTED_JVM_VERSIONS = IntSets.immutable.of(new int[]{17, 21});
    static final String INCOMPATIBLE_JVM_WARNING = "You are using an unsupported Java runtime. Please use Java(TM) 17 or Java(TM) 21 to run Neo4j.";
    static final String INCOMPATIBLE_JVM_VERSION_WARNING = "You are using an unsupported version of the Java runtime. Please use Java(TM) 17 or Java(TM) 21 to run Neo4j.";
    private final InternalLog log;
    private final JvmMetadataRepository jvmMetadataRepository;

    public JvmChecker(InternalLog log, JvmMetadataRepository jvmMetadataRepository) {
        this.log = log;
        this.jvmMetadataRepository = jvmMetadataRepository;
    }

    public void checkJvmCompatibilityAndIssueWarning() {
        String javaVmName = this.jvmMetadataRepository.getJavaVmName();
        Runtime.Version javaVersion = this.jvmMetadataRepository.getJavaVersion();
        if (!SUPPORTED_JAVA_NAME_PATTERN.matcher(javaVmName).matches()) {
            this.log.warn(INCOMPATIBLE_JVM_WARNING);
        } else if (!SUPPORTED_JVM_VERSIONS.contains(javaVersion.feature())) {
            this.log.warn(INCOMPATIBLE_JVM_VERSION_WARNING);
        }
        List<String> jvmArguments = this.jvmMetadataRepository.getJvmInputArguments();
        MemoryUsage heapMemoryUsage = this.jvmMetadataRepository.getHeapMemoryUsage();
        if (JvmChecker.missingOption(jvmArguments, "-Xmx")) {
            this.log.warn(JvmChecker.maxMemorySettingWarning(heapMemoryUsage.getMax()));
        }
        if (JvmChecker.missingOption(jvmArguments, "-Xms")) {
            this.log.warn(JvmChecker.initialMemorySettingWarning(heapMemoryUsage.getInit()));
        }
    }

    static String initialMemorySettingWarning(long currentUsage) {
        return String.format("The initial heap memory has not been configured. It is recommended that it is always explicitly configured, to ensure the system has a balanced configuration. Until then, a JVM computed heuristic of %d bytes is used instead. If you are running neo4j server, you need to configure %s in neo4j.conf. If you are running neo4j embedded, you have to launch the JVM with -Xms set to a value. You can run neo4j-admin server memory-recommendation for memory configuration suggestions.", currentUsage, BootloaderSettings.initial_heap_size.name());
    }

    static String maxMemorySettingWarning(long currentUsage) {
        return String.format("The max heap memory has not been configured. It is recommended that it is always explicitly configured, to ensure the system has a balanced configuration. Until then, a JVM computed heuristic of %d bytes is used instead. If you are running neo4j server, you need to configure %s in neo4j.conf. If you are running neo4j embedded, you have to launch the JVM with -Xmx set to a value. You can run neo4j-admin server memory-recommendation for memory configuration suggestions.", currentUsage, BootloaderSettings.max_heap_size.name());
    }

    private static boolean missingOption(List<String> jvmArguments, String option) {
        String normalizedOption = option.toUpperCase(Locale.ROOT);
        return jvmArguments.stream().noneMatch(o -> o.toUpperCase(Locale.ROOT).startsWith(normalizedOption));
    }
}

