/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionCommitment
implements Commitment {
    private final TransactionIdStore transactionIdStore;
    private boolean committed;
    private long transactionId;
    private int checksum;
    private long consensusIndex;
    private KernelVersion kernelVersion;
    private LogPosition logPositionAfterCommit;
    private long transactionCommitTimestamp;
    private long firstAppendIndex;
    private long currentBatchAppendIndex = 0L;
    private long lastClosedAppendIndex = 0L;

    TransactionCommitment(TransactionIdStore transactionIdStore) {
        this.transactionIdStore = transactionIdStore;
    }

    public void commit(long transactionId, long appendIndex, KernelVersion kernelVersion, LogPosition logPositionAfterCommit, int checksum, long consensusIndex) {
        this.transactionId = transactionId;
        this.kernelVersion = kernelVersion;
        this.logPositionAfterCommit = logPositionAfterCommit;
        this.checksum = checksum;
        this.consensusIndex = consensusIndex;
        this.currentBatchAppendIndex = appendIndex;
        this.transactionIdStore.appendBatch(appendIndex, logPositionAfterCommit);
    }

    public void publishAsCommitted(long transactionCommitTimestamp, long firstAppendIndex) {
        this.committed = true;
        this.firstAppendIndex = firstAppendIndex;
        this.transactionCommitTimestamp = transactionCommitTimestamp;
        this.transactionIdStore.transactionCommitted(this.transactionId, firstAppendIndex, this.kernelVersion, this.checksum, transactionCommitTimestamp, this.consensusIndex);
    }

    public void publishAsClosed() {
        if (this.lastClosedAppendIndex != this.currentBatchAppendIndex) {
            this.transactionIdStore.batchClosed(this.currentBatchAppendIndex, this.kernelVersion, this.logPositionAfterCommit);
            this.lastClosedAppendIndex = this.currentBatchAppendIndex;
        }
        if (this.committed) {
            this.transactionIdStore.transactionClosed(this.transactionId, this.firstAppendIndex, this.kernelVersion, this.logPositionAfterCommit.getLogVersion(), this.logPositionAfterCommit.getByteOffset(), this.checksum, this.transactionCommitTimestamp, this.consensusIndex);
        }
    }
}

