/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class IndexFiles {
    public static final String INDEX_FILE_PREFIX = "index-";
    private final FileSystemAbstraction fs;
    private final Path directory;
    private final Path storeFile;

    public IndexFiles(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure, long indexId) {
        this.fs = fs;
        this.directory = directoryStructure.directoryForIndex(indexId);
        this.storeFile = this.directory.resolve(IndexFiles.indexFileName(indexId));
    }

    public Path getStoreFile() {
        return this.storeFile;
    }

    public Path getBase() {
        return this.directory;
    }

    public void clear() {
        try {
            if (this.fs.fileExists(this.directory)) {
                this.fs.deleteRecursively(this.directory);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void archiveIndex() throws IOException {
        if (this.fs.isDirectory(this.directory) && this.fs.fileExists(this.directory) && this.fs.listFiles(this.directory).length > 0) {
            ZipUtils.zip((FileSystemAbstraction)this.fs, (Path)this.directory, (Path)this.directory.getParent().resolve("archive-" + this.directory.getFileName() + "-" + System.currentTimeMillis() + ".zip"));
        }
    }

    public void ensureDirectoryExist() {
        try {
            this.fs.mkdirs(this.directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return String.format("%s[base=%s,storeFile=%s]", this.getClass().getSimpleName(), this.getBase(), this.getStoreFile());
    }

    private static String indexFileName(long indexId) {
        return INDEX_FILE_PREFIX + indexId;
    }

    public ResourceIterator<Path> snapshot() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.getStoreFile()));
    }
}

