/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.kernel.impl.api.state.EntityStateImpl;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.RelationshipVisitorWithProperties;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.values.storable.Value;

class RelationshipStateImpl
extends EntityStateImpl
implements RelationshipState {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipStateImpl.class);
    static final RelationshipState EMPTY = new RelationshipState(){

        public long getId() {
            throw new UnsupportedOperationException("id not defined");
        }

        public int getType() {
            throw new UnsupportedOperationException("type not defined");
        }

        public long getStartNodeId() {
            throw new UnsupportedOperationException("startNodeId not defined");
        }

        public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) {
            return false;
        }

        public <EX extends Exception> boolean accept(RelationshipVisitorWithProperties<EX> visitor) throws EX {
            return false;
        }

        public Iterable<StorageProperty> addedProperties() {
            return Collections.emptyList();
        }

        public Iterable<StorageProperty> changedProperties() {
            return Collections.emptyList();
        }

        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        public Iterable<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyList();
        }

        public boolean hasPropertyChanges() {
            return false;
        }

        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        public boolean isPropertyAdded(int propertyKey) {
            return false;
        }

        public Value propertyValue(int propertyKey) {
            return null;
        }
    };
    private final long startNode;
    private final long endNode;
    private final int type;
    private boolean deleted;

    static RelationshipStateImpl createRelationshipStateImpl(long id, int type, long startNode, long endNode, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new RelationshipStateImpl(id, type, startNode, endNode, collectionsFactory, memoryTracker);
    }

    private RelationshipStateImpl(long id, int type, long startNode, long endNode, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        super(id, collectionsFactory, memoryTracker);
        this.type = type;
        this.startNode = startNode;
        this.endNode = endNode;
    }

    void setDeleted() {
        this.deleted = true;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    public int getType() {
        return this.type;
    }

    public long getStartNodeId() {
        return this.startNode;
    }

    public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) throws EX {
        if (this.type != -1) {
            visitor.visit(this.getId(), this.type, this.startNode, this.endNode);
            return true;
        }
        return false;
    }

    public <EX extends Exception> boolean accept(RelationshipVisitorWithProperties<EX> visitor) throws EX {
        if (this.type != -1) {
            visitor.visit(this.getId(), this.type, this.startNode, this.endNode, this.addedProperties());
            return true;
        }
        return false;
    }
}

