/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.recovery.TransactionStatus;
import org.neo4j.storageengine.api.CommandBatch;

public class TransactionIdTracker {
    private final MutableLongSet completedTransactionsWindow = LongSets.mutable.empty();
    private final MutableLongSet rollbackTransactions = LongSets.mutable.empty();
    private final MutableLongSet notCompletedTransactions = LongSets.mutable.empty();

    TransactionStatus transactionStatus(long transactionId) {
        if (this.notCompletedTransactions.contains(transactionId)) {
            return TransactionStatus.INCOMPLETE;
        }
        if (this.rollbackTransactions.contains(transactionId)) {
            return TransactionStatus.ROLLED_BACK;
        }
        return TransactionStatus.RECOVERABLE;
    }

    long[] notCompletedTransactions() {
        return this.notCompletedTransactions.toSortedArray();
    }

    public void trackBatch(CommittedCommandBatch committedBatch) {
        CommandBatch commandBatch = committedBatch.commandBatch();
        if (commandBatch.isFirst() && commandBatch.isLast()) {
            return;
        }
        long transactionId = committedBatch.txId();
        if (commandBatch.isLast()) {
            this.completedTransactionsWindow.add(transactionId);
            if (committedBatch.isRollback()) {
                this.rollbackTransactions.add(transactionId);
            }
        } else {
            if (!this.completedTransactionsWindow.contains(transactionId)) {
                this.notCompletedTransactions.add(transactionId);
            }
            if (commandBatch.isFirst()) {
                this.completedTransactionsWindow.remove(transactionId);
            }
        }
    }
}

