/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.neo4j.graphdb.Direction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityScanCursorBehaviour;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.EagerDegrees;

public class NodeRelationshipTypesCursorBehaviour
implements EntityScanCursorBehaviour<StorageNodeCursor> {
    private final StorageReader storageReader;

    NodeRelationshipTypesCursorBehaviour(StorageReader storageReader) {
        this.storageReader = storageReader;
    }

    @Override
    public StorageNodeCursor allocateEntityScanCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return this.storageReader.allocateNodeCursor(cursorContext, storeCursors);
    }

    @Override
    public int[] readTokens(StorageNodeCursor cursor) {
        EagerDegrees degrees = new EagerDegrees();
        cursor.degrees(RelationshipSelection.selection((Direction)Direction.OUTGOING), (Degrees.Mutator)degrees);
        MutableIntList types = IntLists.mutable.empty();
        for (int type : degrees.types()) {
            if (degrees.outgoingDegree(type) <= 0) continue;
            types.add(type);
        }
        return types.toSortedArray();
    }
}

