/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.log.LogIndexEncoding;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public record CommittedTransactionRepresentation(LogEntryStart startEntry, CommandBatch commandBatch, LogEntryCommit commitEntry) implements CommittedCommandBatch
{
    public CommittedTransactionRepresentation(LogEntryStart startEntry, List<StorageCommand> commands, LogEntryCommit commitEntry) {
        this(startEntry, new CompleteTransaction(commands, LogIndexEncoding.decodeLogIndex(startEntry.getAdditionalHeader()), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), commitEntry.getTimeWritten(), -1, startEntry.kernelVersion(), Subject.ANONYMOUS), commitEntry);
    }

    @Override
    public int serialize(LogEntryWriter<? extends WritableChannel> writer) throws IOException {
        KernelVersion kernelVersion = this.startEntry.kernelVersion();
        writer.writeStartEntry(kernelVersion, this.startEntry.getTimeWritten(), this.startEntry.getLastCommittedTxWhenTransactionStarted(), this.startEntry.getAppendIndex(), this.startEntry.getPreviousChecksum(), this.startEntry.getAdditionalHeader());
        writer.serialize(this.commandBatch);
        return writer.writeCommitEntry(kernelVersion, this.commitEntry.getTxId(), this.commitEntry.getTimeWritten());
    }

    @Override
    public long appendIndex() {
        return this.startEntry.kernelVersion().isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED) ? this.startEntry.getAppendIndex() : this.commitEntry.getTxId();
    }

    @Override
    public int checksum() {
        return this.commitEntry.getChecksum();
    }

    @Override
    public long timeWritten() {
        return this.commitEntry.getTimeWritten();
    }

    @Override
    public long txId() {
        return this.commitEntry.getTxId();
    }

    @Override
    public boolean isRollback() {
        return false;
    }

    @Override
    public LogPosition previousBatchLogPosition() {
        return LogPosition.UNSPECIFIED;
    }

    @Override
    public String toString() {
        return "CommittedTransactionRepresentation{startEntry=" + this.startEntry + ", transactionRepresentation=" + this.commandBatch + ", commitEntry=" + this.commitEntry + "}";
    }
}

