/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultTokenReadSession;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.InternalRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.PartitionedNodeCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedRelationshipCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedTokenIndexCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedValueIndexCursorSeek;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.Preconditions;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
SchemaRead,
Procedures {
    protected final StorageReader storageReader;
    protected final DefaultPooledCursors cursors;
    private final TokenRead tokenRead;
    protected final StoreCursors storageCursors;
    protected final QueryContext queryContext;
    protected final Locks entityLocks;

    Read(StorageReader storageReader, TokenRead tokenRead, DefaultPooledCursors cursors, StoreCursors storageCursors, Locks entityLocks, QueryContext queryContext) {
        this.storageReader = storageReader;
        this.tokenRead = tokenRead;
        this.cursors = cursors;
        this.storageCursors = storageCursors;
        this.entityLocks = entityLocks;
        this.queryContext = queryContext;
    }

    public final void nodeIndexSeek(QueryContext queryContext, IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        this.validateConstraints(constraints, indexSession);
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index seek can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        indexSession.reader.query((IndexProgressor.EntityValueClient)client, queryContext, constraints, query);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index seek can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public final void relationshipIndexSeek(QueryContext queryContext, IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        this.validateConstraints(constraints, indexSession);
        if (indexSession.reference.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index seek can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        indexSession.reader.query((IndexProgressor.EntityValueClient)client, queryContext, constraints, query);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index seek can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IndexNotApplicableKernelException("Multi-token index " + index + " does not support uniqueness.");
        }
        long indexEntryId = ResourceIds.indexEntryResourceId(entityTokenIds[0], predicates);
        this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
        try (IndexReaders readers = new IndexReaders(index, this);){
            this.nodeIndexSeekWithFreshIndexReader((DefaultNodeValueIndexCursor)cursor, readers.createReader(), predicates);
            if (!cursor.next()) {
                this.entityLocks.releaseSharedIndexEntryLock(new long[]{indexEntryId});
                this.entityLocks.acquireExclusiveIndexEntryLock(new long[]{indexEntryId});
                this.nodeIndexSeekWithFreshIndexReader((DefaultNodeValueIndexCursor)cursor, readers.createReader(), predicates);
                if (cursor.next()) {
                    this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
                    this.entityLocks.releaseExclusiveIndexEntryLock(new long[]{indexEntryId});
                    long l = cursor.nodeReference();
                    return l;
                }
                long l = -1L;
                return l;
            }
            long l = cursor.nodeReference();
            return l;
        }
    }

    public long lockingRelationshipUniqueIndexSeek(IndexDescriptor index, RelationshipValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws KernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IndexNotApplicableKernelException("Multi-token index " + index + " does not support uniqueness.");
        }
        long indexEntryId = ResourceIds.indexEntryResourceId(entityTokenIds[0], predicates);
        this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
        try (IndexReaders readers = new IndexReaders(index, this);){
            DefaultRelationshipValueIndexCursor indexCursor = (DefaultRelationshipValueIndexCursor)cursor;
            this.relationshipIndexSeekWithFreshIndexReader(indexCursor, readers.createReader(), predicates);
            if (!cursor.next()) {
                this.entityLocks.releaseSharedIndexEntryLock(new long[]{indexEntryId});
                this.entityLocks.acquireExclusiveIndexEntryLock(new long[]{indexEntryId});
                this.relationshipIndexSeekWithFreshIndexReader(indexCursor, readers.createReader(), predicates);
                if (cursor.next()) {
                    this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
                    this.entityLocks.releaseExclusiveIndexEntryLock(new long[]{indexEntryId});
                    long l = cursor.relationshipReference();
                    return l;
                }
                long l = -1L;
                return l;
            }
            long l = cursor.relationshipReference();
            return l;
        }
    }

    public void nodeIndexSeekWithFreshIndexReader(DefaultNodeValueIndexCursor cursor, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.setRead(this);
        indexReader.query((IndexProgressor.EntityValueClient)cursor, this.queryContext, IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    public void relationshipIndexSeekWithFreshIndexReader(DefaultRelationshipValueIndexCursor cursor, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.setRead(this);
        indexReader.query((IndexProgressor.EntityValueClient)cursor, this.queryContext, IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    public final void nodeIndexScan(IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index scan can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index scan can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    public final void relationshipIndexScan(IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index scan can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index scan can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    private void scanIndex(DefaultIndexReadSession indexSession, EntityIndexSeekClient indexSeekClient, IndexQueryConstraints constraints) throws KernelException {
        indexSeekClient.setRead(this);
        indexSession.reader.query((IndexProgressor.EntityValueClient)indexSeekClient, this.queryContext, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
    }

    public final PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public final PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, PartitionedScan<NodeLabelIndexCursor> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, leadingPartitionScan, query);
    }

    public final List<PartitionedScan<NodeLabelIndexCursor>> nodeLabelScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public final void nodeLabelScan(TokenReadSession session, NodeLabelIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this);
        tokenSession.reader.query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, cursorContext);
    }

    public final void allNodesScan(NodeCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultNodeCursor)cursor).scan(this);
    }

    public final void singleNode(long reference, NodeCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultNodeCursor)cursor).single(reference, this);
    }

    public PartitionedScan<NodeCursor> allNodesScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        this.performCheckBeforeOperation();
        long totalCount = this.storageReader.nodesGetCount(cursorContext);
        return new PartitionedNodeCursorScan(this.storageReader.allNodeScan(), desiredNumberOfPartitions, totalCount);
    }

    public PartitionedScan<RelationshipScanCursor> allRelationshipsScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        this.performCheckBeforeOperation();
        long totalCount = this.storageReader.relationshipsGetCount(cursorContext);
        return new PartitionedRelationshipCursorScan(this.storageReader.allRelationshipScan(), desiredNumberOfPartitions, totalCount);
    }

    public final void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this);
    }

    public void singleRelationship(long reference, long sourceNodeReference, int type, long targetNodeReference, RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).single(reference, sourceNodeReference, type, targetNodeReference, this);
    }

    public final void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).scan(this);
    }

    public final PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public final PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, PartitionedScan<RelationshipTypeIndexCursor> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, leadingPartitionScan, query);
    }

    public final List<PartitionedScan<RelationshipTypeIndexCursor>> relationshipTypeScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public final void relationshipTypeScan(TokenReadSession session, RelationshipTypeIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        InternalRelationshipTypeIndexCursor indexCursor = (InternalRelationshipTypeIndexCursor)cursor;
        indexCursor.setRead(this);
        tokenSession.reader.query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, cursorContext);
    }

    public void relationships(long nodeReference, long reference, RelationshipSelection selection, RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, reference, selection, this);
    }

    public void nodeProperties(long nodeReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, selection, this);
    }

    public void relationshipProperties(long relationshipReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, selection, this);
    }

    private void validateConstraints(IndexQueryConstraints constraints, DefaultIndexReadSession indexSession) {
        if (constraints.needsValues() && !indexSession.reference().getCapability().supportsReturningValues()) {
            throw new UnsupportedOperationException(String.format("%s index has no value capability", indexSession.reference().getIndexType()));
        }
    }

    private <C extends Cursor> PartitionedScan<C> propertyIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
    }

    private <C extends Cursor> PartitionedScan<C> propertyIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (!descriptor.getCapability().supportPartitionedScan((IndexQuery[])query)) {
            throw new IndexNotApplicableKernelException("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        if (this.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        DefaultIndexReadSession session = (DefaultIndexReadSession)index;
        PartitionedValueSeek valueSeek = session.reader.valueSeek(desiredNumberOfPartitions, queryContext, query);
        return new PartitionedValueIndexCursorSeek(descriptor, valueSeek, query);
    }

    private <C extends Cursor> PartitionedScan<C> tokenIndexScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = session.reference();
        if (!descriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})) {
            throw new IndexNotApplicableKernelException("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        if (this.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        DefaultTokenReadSession defaultSession = (DefaultTokenReadSession)session;
        PartitionedTokenScan tokenScan = defaultSession.reader.entityTokenScan(desiredNumberOfPartitions, cursorContext, query);
        return new PartitionedTokenIndexCursorScan(query, tokenScan);
    }

    private <C extends Cursor> PartitionedScan<C> tokenIndexScan(TokenReadSession session, PartitionedScan<C> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = session.reference();
        if (!descriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})) {
            throw new IndexNotApplicableKernelException("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        if (this.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        DefaultTokenReadSession defaultSession = (DefaultTokenReadSession)session;
        PartitionedTokenIndexCursorScan leadingTokenIndexCursorScan = (PartitionedTokenIndexCursorScan)leadingPartitionScan;
        PartitionedTokenScan tokenScan = defaultSession.reader.entityTokenScan(leadingTokenIndexCursorScan.getTokenScan(), query);
        return new PartitionedTokenIndexCursorScan(query, tokenScan);
    }

    private <C extends Cursor> List<PartitionedScan<C>> tokenIndexScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        Preconditions.requireNonEmpty((Object[])queries);
        ArrayList<PartitionedScan<C>> scans = new ArrayList<PartitionedScan<C>>(queries.length);
        PartitionedScan<C> leadingPartitionScan = this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries[0]);
        scans.add(leadingPartitionScan);
        for (int i = 1; i < queries.length; ++i) {
            scans.add(this.tokenIndexScan(session, leadingPartitionScan, queries[i]));
        }
        return scans;
    }

    public abstract ValueIndexReader newValueIndexReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    private void assertIndexOnline(IndexDescriptor index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.indexGetState(index) == InternalIndexState.ONLINE) {
            return;
        }
        throw new IndexBrokenKernelException(this.indexGetFailure(index));
    }

    private static void assertPredicatesMatchSchema(IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.schema().getPropertyIds();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    abstract void performCheckBeforeOperation();

    abstract AccessMode getAccessMode();
}

