/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

class DefaultRelationshipScanCursor
extends DefaultRelationshipCursor
implements RelationshipScanCursor {
    private final StorageRelationshipScanCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private long single;
    private boolean isSingle;
    private LongIterator addedRelationships;
    private DefaultNodeCursor securityNodeCursor;

    DefaultRelationshipScanCursor(CursorPool<DefaultRelationshipScanCursor> pool, StorageRelationshipScanCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super((StorageRelationshipCursor)storeCursor, pool);
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    void scan(Read read) {
        this.storeCursor.scan();
        this.single = -1L;
        this.isSingle = false;
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    boolean scanBatch(Read read, AllRelationshipsScan scan, long sizeHint, LongIterator addedRelationships, boolean hasChanges) {
        this.read = read;
        this.single = -1L;
        this.isSingle = false;
        this.currentAddedInTx = -1L;
        this.addedRelationships = addedRelationships;
        this.hasChanges = hasChanges;
        this.checkHasChanges = false;
        boolean scanBatch = this.storeCursor.scanBatch((Scan)scan, sizeHint);
        return addedRelationships.hasNext() || scanBatch;
    }

    void single(long reference, Read read) {
        this.storeCursor.single(reference);
        this.single = reference;
        this.isSingle = true;
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    void single(long reference, long sourceNodeReference, int type, long targetNodeReference, Read read) {
        this.storeCursor.single(reference, sourceNodeReference, type, targetNodeReference);
        this.single = reference;
        this.isSingle = true;
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            while (this.addedRelationships.hasNext()) {
                long next = this.addedRelationships.next();
                this.read.txState().relationshipVisit(next, this.relationshipTxStateDataVisitor);
                if (this.applyAccessModeToTxState && !this.allowed()) continue;
                if (this.tracer != null) {
                    this.tracer.onRelationship(this.relationshipReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            boolean skip = hasChanges && this.read.txState().relationshipIsDeletedInThisBatch(this.storeCursor.entityReference());
            if (skip || !this.allowed()) continue;
            if (this.tracer != null) {
                this.tracer.onRelationship(this.relationshipReference());
            }
            return true;
        }
        return false;
    }

    protected boolean allowed() {
        AccessMode accessMode = this.read.getAccessMode();
        return accessMode.allowsTraverseRelType(this.type()) && this.allowedToSeeEndNode(accessMode);
    }

    private boolean allowedToSeeEndNode(AccessMode mode) {
        if (mode.allowsTraverseAllLabels()) {
            return true;
        }
        if (this.securityNodeCursor == null) {
            this.securityNodeCursor = this.internalCursors.allocateNodeCursor();
        }
        if (this.applyAccessModeToTxState && this.currentAddedInTx != -1L) {
            this.read.singleNode(this.txStateSourceNodeReference, this.securityNodeCursor);
        } else {
            this.read.singleNode(this.storeCursor.sourceNodeReference(), this.securityNodeCursor);
        }
        if (this.securityNodeCursor.next()) {
            if (this.applyAccessModeToTxState && this.currentAddedInTx != -1L) {
                this.read.singleNode(this.txStateTargetNodeReference, this.securityNodeCursor);
            } else {
                this.read.singleNode(this.storeCursor.targetNodeReference(), this.securityNodeCursor);
            }
            return this.securityNodeCursor.next();
        }
        return false;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.storeCursor.close();
            if (this.securityNodeCursor != null) {
                this.securityNodeCursor.close();
                this.securityNodeCursor.release();
                this.securityNodeCursor = null;
            }
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + this.storeCursor.entityReference() + ", open state with: single=" + this.single + ", " + this.storeCursor + "]";
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        this.addedRelationships = this.isSingle ? (this.read.txState().relationshipIsAddedInThisBatch(this.single) ? LongHashSet.newSetWith((long[])new long[]{this.single}).longIterator() : ImmutableEmptyLongIterator.INSTANCE) : this.read.txState().addedAndRemovedRelationships().getAdded().longIterator();
    }

    @Override
    public void release() {
        if (this.storeCursor != null) {
            this.storeCursor.close();
        }
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
    }
}

