/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.executor.ProcessorScheduler;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityScanCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.GenerateIndexUpdatesStep;
import org.neo4j.kernel.impl.transaction.state.storeview.ReadEntityIdsStep;
import org.neo4j.kernel.impl.transaction.state.storeview.WriteUpdatesStep;
import org.neo4j.lock.Lock;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class StoreScanStage<CURSOR extends StorageEntityScanCursor<?>>
extends Stage {
    private final ReadEntityIdsStep feedStep;
    private final GenerateIndexUpdatesStep<CURSOR> generatorStep;
    private WriteUpdatesStep writeStep;

    public StoreScanStage(Config dbConfig, Configuration config, BiFunction<CursorContext, StoreCursors, EntityIdIterator> entityIdIteratorSupplier, StoreScan.ExternalUpdatesCheck externalUpdatesCheck, AtomicBoolean continueScanning, StorageReader storageReader, Function<CursorContext, StoreCursors> storeCursorsFactory, int[] entityTokenIdFilter, PropertySelection propertySelection, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer tokenScanConsumer, EntityScanCursorBehaviour<CURSOR> entityCursorBehaviour, LongFunction<Lock> lockFunction, boolean parallelWrite, JobScheduler scheduler, CursorContextFactory contextFactory, MemoryTracker memoryTracker, boolean canDetermineExternalUpdatesCutOffPoint) {
        super("IndexPopulation store scan", null, config, parallelWrite ? 0 : 1, StoreScanStage.runInJobScheduler(scheduler), StageExecution.DEFAULT_PANIC_MONITOR);
        int parallelism = (Integer)dbConfig.get(GraphDatabaseInternalSettings.index_population_workers);
        long maxBatchByteSize = (Long)dbConfig.get(GraphDatabaseInternalSettings.index_population_batch_max_byte_size);
        this.feedStep = new ReadEntityIdsStep(this.control(), config, entityIdIteratorSupplier, storeCursorsFactory, contextFactory, externalUpdatesCheck, continueScanning, canDetermineExternalUpdatesCutOffPoint);
        this.add((Step)this.feedStep);
        this.generatorStep = new GenerateIndexUpdatesStep<CURSOR>(this.control(), config, storageReader, storeCursorsFactory, propertySelection, entityCursorBehaviour, entityTokenIdFilter, propertyScanConsumer, tokenScanConsumer, lockFunction, parallelism, maxBatchByteSize, parallelWrite, contextFactory, memoryTracker);
        this.add((Step)this.generatorStep);
        if (!parallelWrite) {
            this.writeStep = new WriteUpdatesStep(this.control(), config, contextFactory);
            this.add((Step)this.writeStep);
        }
    }

    private static ProcessorScheduler runInJobScheduler(JobScheduler scheduler) {
        return (job, name) -> scheduler.schedule(Group.INDEX_POPULATION_WORK, job);
    }

    void reportTo(PhaseTracker phaseTracker) {
        long scanNanos = this.feedStep.stats().stat((Key)Keys.total_processing_wall_clock_time).asLong() + this.generatorStep.stats().stat((Key)Keys.total_processing_wall_clock_time).asLong();
        phaseTracker.registerTime(PhaseTracker.Phase.SCAN, TimeUnit.NANOSECONDS.toMillis(scanNanos));
        if (this.writeStep != null) {
            long writeNanos = this.writeStep.stats().stat((Key)Keys.total_processing_wall_clock_time).asLong();
            phaseTracker.registerTime(PhaseTracker.Phase.WRITE, TimeUnit.NANOSECONDS.toMillis(writeNanos));
        }
    }

    long numberOfCompletedEntities() {
        return this.generatorStep.numberOfCompletedEntities();
    }
}

