/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Objects;
import org.neo4j.internal.helpers.collection.LfuCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private static final int DEFAULT_TRANSACTION_CACHE_SIZE = 10000;
    private final LfuCache<Long, TransactionMetadata> txIdMetadataCache = new LfuCache("Tx start position cache", 10000);

    public void clear() {
        this.txIdMetadataCache.clear();
    }

    public TransactionMetadata getTransactionMetadata(long txId) {
        return (TransactionMetadata)this.txIdMetadataCache.get((Object)txId);
    }

    public void cacheTransactionMetadata(long txId, LogPosition position) {
        if (LogPosition.UNSPECIFIED == position) {
            throw new IllegalArgumentException("Metadata cache only supports specified log positions.");
        }
        TransactionMetadata result = new TransactionMetadata(position);
        this.txIdMetadataCache.put((Object)txId, (Object)result);
    }

    public record TransactionMetadata(LogPosition startPosition) {
        @Override
        public String toString() {
            return "TransactionMetadata{, startPosition=" + this.startPosition + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            return Objects.equals(this.startPosition, that.startPosition);
        }
    }
}

