/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionCommitment
implements Commitment {
    private final TransactionMetadataCache transactionMetadataCache;
    private final TransactionIdStore transactionIdStore;
    private boolean committed;
    private long transactionId;
    private long appendIndex;
    private int checksum;
    private long consensusIndex;
    private KernelVersion kernelVersion;
    private LogPosition logPositionAfterCommit;
    private long transactionCommitTimestamp;

    TransactionCommitment(TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore) {
        this.transactionMetadataCache = transactionMetadataCache;
        this.transactionIdStore = transactionIdStore;
    }

    public void commit(long transactionId, long appendIndex, KernelVersion kernelVersion, LogPosition beforeCommit, LogPosition logPositionAfterCommit, int checksum, long consensusIndex) {
        this.transactionId = transactionId;
        this.kernelVersion = kernelVersion;
        this.logPositionAfterCommit = logPositionAfterCommit;
        this.checksum = checksum;
        this.consensusIndex = consensusIndex;
        this.transactionIdStore.appendBatch(appendIndex, beforeCommit);
    }

    public void publishAsCommitted(long transactionCommitTimestamp, long appendIndex, LogPosition beforeCommit) {
        this.committed = true;
        this.appendIndex = appendIndex;
        this.transactionCommitTimestamp = transactionCommitTimestamp;
        this.transactionMetadataCache.cacheTransactionMetadata(this.transactionId, beforeCommit);
        this.transactionIdStore.transactionCommitted(this.transactionId, appendIndex, this.kernelVersion, this.checksum, transactionCommitTimestamp, this.consensusIndex);
    }

    public void publishAsClosed() {
        if (this.committed) {
            this.transactionIdStore.transactionClosed(this.transactionId, this.appendIndex, this.kernelVersion, this.logPositionAfterCommit.getLogVersion(), this.logPositionAfterCommit.getByteOffset(), this.checksum, this.transactionCommitTimestamp, this.consensusIndex);
        }
    }
}

