/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.OptionalInt;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.PhysicalFlushableLogChannel;
import org.neo4j.io.fs.PhysicalLogChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.EnvelopeWriteChannel;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class PhysicalFlushableLogPositionAwareChannel
implements FlushableLogPositionAwareChannel {
    private final PhysicalFlushableLogChannelProvider channelProvider;
    private LogVersionedStoreChannel logVersionedStoreChannel;
    private PhysicalLogChannel checksumChannel;

    @VisibleForTesting
    public PhysicalFlushableLogPositionAwareChannel(LogVersionedStoreChannel logVersionedStoreChannel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        this(logVersionedStoreChannel, logHeader, new SingleLogFileChannelProvider(memoryTracker));
    }

    public PhysicalFlushableLogPositionAwareChannel(LogVersionedStoreChannel logVersionedStoreChannel, LogHeader logHeader, PhysicalFlushableLogChannelProvider channelProvider) throws IOException {
        this.channelProvider = channelProvider;
        this.setChannel(logVersionedStoreChannel, logHeader);
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.logVersionedStoreChannel.getLogVersion(), this.checksumChannel.position());
        return positionMarker;
    }

    public LogPosition getCurrentLogPosition() throws IOException {
        return new LogPosition(this.logVersionedStoreChannel.getLogVersion(), this.checksumChannel.position());
    }

    public void setLogPosition(LogPositionMarker positionMarker) throws IOException {
        if (positionMarker.getLogVersion() != this.logVersionedStoreChannel.getLogVersion()) {
            throw new IllegalArgumentException("Log position points log version %d but the current one is %d".formatted(positionMarker.getLogVersion(), this.logVersionedStoreChannel.getLogVersion()));
        }
        this.logVersionedStoreChannel.position(positionMarker.getByteOffset());
    }

    public Flushable prepareForFlush() throws IOException {
        return this.checksumChannel.prepareForFlush();
    }

    public int putChecksum() throws IOException {
        return this.checksumChannel.putChecksum();
    }

    public void resetAppendedBytesCounter() {
        this.checksumChannel.resetAppendedBytesCounter();
    }

    public void beginChecksumForWriting() {
        this.checksumChannel.beginChecksumForWriting();
    }

    public long getAppendedBytes() {
        return this.checksumChannel.getAppendedBytes();
    }

    public FlushableChannel put(byte value) throws IOException {
        return this.checksumChannel.put(value);
    }

    public FlushableChannel putShort(short value) throws IOException {
        return this.checksumChannel.putShort(value);
    }

    public FlushableChannel putInt(int value) throws IOException {
        return this.checksumChannel.putInt(value);
    }

    public FlushableChannel putLong(long value) throws IOException {
        return this.checksumChannel.putLong(value);
    }

    public FlushableChannel putFloat(float value) throws IOException {
        return this.checksumChannel.putFloat(value);
    }

    public FlushableChannel putDouble(double value) throws IOException {
        return this.checksumChannel.putDouble(value);
    }

    public FlushableChannel put(byte[] value, int offset, int length) throws IOException {
        return this.checksumChannel.put(value, offset, length);
    }

    public FlushableChannel putAll(ByteBuffer src) throws IOException {
        return this.checksumChannel.putAll(src);
    }

    public FlushableChannel putVersion(byte version) throws IOException {
        return this.checksumChannel.putVersion(version);
    }

    public boolean isOpen() {
        return this.checksumChannel.isOpen();
    }

    public void close() throws IOException {
        this.checksumChannel.close();
    }

    public int write(ByteBuffer buffer) throws IOException {
        int remaining = buffer.remaining();
        this.checksumChannel.putAll(buffer);
        return remaining;
    }

    public void setChannel(LogVersionedStoreChannel logChannel, LogHeader logHeader) throws IOException {
        LogVersionedStoreChannel prevLogChannel = this.logVersionedStoreChannel;
        this.logVersionedStoreChannel = logChannel;
        if (this.channelProvider.isNewChannelRequired(prevLogChannel, logChannel)) {
            this.checksumChannel = this.channelProvider.create(logChannel, logHeader);
        } else {
            this.checksumChannel.setChannel((StoreChannel)logChannel);
        }
    }

    public OptionalInt currentChecksum() {
        PhysicalLogChannel physicalLogChannel = this.checksumChannel;
        if (physicalLogChannel instanceof EnvelopeWriteChannel) {
            EnvelopeWriteChannel writeChannel = (EnvelopeWriteChannel)physicalLogChannel;
            return OptionalInt.of(writeChannel.currentChecksum());
        }
        return OptionalInt.empty();
    }

    private record SingleLogFileChannelProvider(MemoryTracker memoryTracker) implements PhysicalFlushableLogChannelProvider
    {
        @Override
        public boolean isNewChannelRequired(LogVersionedStoreChannel currentChannel, LogVersionedStoreChannel newLogChannel) {
            return currentChannel == null;
        }

        @Override
        public PhysicalLogChannel create(LogVersionedStoreChannel logChannel, LogHeader logHeader) throws IOException {
            if (logChannel.getLogFormatVersion().usesSegments()) {
                return new EnvelopeWriteChannel((StoreChannel)logChannel, (ScopedBuffer)new HeapScopedBuffer(logHeader.getSegmentBlockSize(), ByteOrder.LITTLE_ENDIAN, this.memoryTracker), logHeader.getSegmentBlockSize(), logHeader.getPreviousLogFileChecksum(), 0L, DatabaseTracer.NULL, LogRotation.NO_ROTATION);
            }
            return new PhysicalFlushableLogChannel((StoreChannel)logChannel, (ScopedBuffer)new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)128L), ByteOrder.LITTLE_ENDIAN, this.memoryTracker));
        }
    }

    public static interface PhysicalFlushableLogChannelProvider {
        public boolean isNewChannelRequired(LogVersionedStoreChannel var1, LogVersionedStoreChannel var2);

        public PhysicalLogChannel create(LogVersionedStoreChannel var1, LogHeader var2) throws IOException;
    }

    public static class VersionedPhysicalFlushableLogChannelProvider
    implements PhysicalFlushableLogChannelProvider {
        private final LogRotation logRotation;
        private final DatabaseTracer databaseTracer;
        private final ScopedBuffer buffer;

        public VersionedPhysicalFlushableLogChannelProvider(LogRotation logRotation, DatabaseTracer databaseTracer, ScopedBuffer buffer) {
            this.logRotation = Objects.requireNonNull(logRotation);
            this.databaseTracer = Objects.requireNonNull(databaseTracer);
            this.buffer = Objects.requireNonNull(buffer);
        }

        @Override
        public boolean isNewChannelRequired(LogVersionedStoreChannel currentChannel, LogVersionedStoreChannel newLogChannel) {
            return currentChannel == null || currentChannel.getLogFormatVersion().usesSegments() != newLogChannel.getLogFormatVersion().usesSegments();
        }

        @Override
        public PhysicalLogChannel create(LogVersionedStoreChannel logChannel, LogHeader logHeader) throws IOException {
            if (logChannel.getLogFormatVersion().usesSegments()) {
                int previousChecksum = logHeader.getPreviousLogFileChecksum();
                long position = logChannel.position();
                if (position != logHeader.getStartPosition().getByteOffset()) {
                    try (NativeScopedBuffer buffer = new NativeScopedBuffer(logHeader.getSegmentBlockSize(), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                        EnvelopeReadChannel envelopeReadChannel = new EnvelopeReadChannel(logChannel, logHeader.getSegmentBlockSize(), LogVersionBridge.NO_MORE_CHANNELS, true, (ScopedBuffer)buffer);
                        previousChecksum = envelopeReadChannel.temporaryFindPreviousChecksumBeforePosition(position);
                        logChannel.position(position);
                    }
                }
                return new EnvelopeWriteChannel((StoreChannel)logChannel, this.buffer, logHeader.getSegmentBlockSize(), previousChecksum, 0L, this.databaseTracer, this.logRotation);
            }
            return new PhysicalFlushableLogChannel((StoreChannel)logChannel, this.buffer);
        }
    }
}

