/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.URL;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class WebUrlAccessChecker
implements URLAccessChecker {
    private final WebURLAccessRule webURLAccessRule;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final SecurityContext securityContext;

    public WebUrlAccessChecker(WebURLAccessRule webURLAccessRule, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) {
        this.webURLAccessRule = webURLAccessRule;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
        this.securityContext = securityContext;
    }

    public URL checkURL(URL url) throws URLAccessValidationError {
        try {
            return this.webURLAccessRule.checkNotBlockedAndPinToIP(url, this.securityAuthorizationHandler, this.securityContext);
        }
        catch (Exception e) {
            if (e instanceof URLAccessValidationError) {
                throw (URLAccessValidationError)e;
            }
            throw new URLAccessValidationError("Unable to verify access to " + url.getHost() + ". Cause: " + e.getMessage());
        }
    }
}

