/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Supplier;
import org.neo4j.cloud.storage.SchemeFileSystemAbstraction;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.AccessRule;

public class FileURIAccessRule
implements AccessRule<URI> {
    private final Supplier<SchemeFileSystemAbstraction> schemeSystemSupplier;
    private final Config config;

    public FileURIAccessRule(Config config) {
        this(() -> new SchemeFileSystemAbstraction((FileSystemAbstraction)new DefaultFileSystemAbstraction(), config), config);
    }

    public FileURIAccessRule(Supplier<SchemeFileSystemAbstraction> schemeSystemSupplier, Config config) {
        this.schemeSystemSupplier = schemeSystemSupplier;
        this.config = config;
    }

    public URI validate(URI uri, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws URLAccessValidationError {
        boolean fileLikeScheme = this.isFileLikeScheme(uri);
        if (fileLikeScheme && uri.getAuthority() != null && !uri.getAuthority().isEmpty()) {
            throw new URLAccessValidationError("file URL may not contain an authority section (i.e. it should be 'file:///')");
        }
        if (uri.getQuery() != null && !uri.getQuery().isEmpty()) {
            throw new URLAccessValidationError("file URL may not contain a query component");
        }
        if (!((Boolean)this.config.get(GraphDatabaseSettings.allow_file_urls)).booleanValue()) {
            throw new URLAccessValidationError("configuration property '" + GraphDatabaseSettings.allow_file_urls.name() + "' is false");
        }
        try {
            URI result = fileLikeScheme ? this.normalizeURI(uri) : uri.normalize();
            securityAuthorizationHandler.assertLoadAllowed(securityContext, result, null);
            return result;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharReadable getReader(URI uri, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws URLAccessValidationError, IOException {
        String scheme = uri.getScheme().toLowerCase(Locale.ROOT);
        try (SchemeFileSystemAbstraction fs = this.schemeSystemSupplier.get();){
            if (!fs.resolvableSchemes().contains(scheme)) {
                throw new URLAccessValidationError("Invalid URL '" + uri + "': unknown protocol: " + scheme);
            }
            if (!fs.canResolve(uri)) {
                throw new URLAccessValidationError("loading resources via protocol '" + scheme + "' is not permitted");
            }
            Path path = fs.resolve(this.validate(uri, securityAuthorizationHandler, securityContext));
            CharReadable charReadable = Readables.files((Charset)StandardCharsets.UTF_8, (Path[])new Path[]{path});
            return charReadable;
        }
    }

    private boolean isFileLikeScheme(URI uri) {
        String scheme = uri.getScheme();
        return scheme == null || "file".equalsIgnoreCase(scheme);
    }

    private URI normalizeURI(URI uri) throws URISyntaxException, URLAccessValidationError {
        if (!this.config.isExplicitlySet(GraphDatabaseSettings.load_csv_file_url_root)) {
            return uri;
        }
        Path root = (Path)this.config.get(GraphDatabaseSettings.load_csv_file_url_root);
        Path uriPath = Path.of(uri.normalize());
        Path rootPath = root.normalize().toAbsolutePath();
        Path result = rootPath.resolve(uriPath.getRoot().relativize(uriPath)).normalize().toAbsolutePath();
        if (result.startsWith(rootPath)) {
            return result.toUri();
        }
        throw new URLAccessValidationError("file URL points outside configured import directory");
    }
}

