/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.IntSupplier;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.id.IdCapacityExceededException;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.KernelTokenRead;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class KernelToken
extends KernelTokenRead
implements Token {
    private final StorageReader store;
    private final CommandCreationContext commandCreationContext;
    private final KernelTransactionImplementation ktx;
    private final TokenHolders tokenHolders;

    public KernelToken(StorageReader store, CommandCreationContext commandCreationContext, KernelTransactionImplementation ktx, TokenHolders tokenHolders) {
        super(store, tokenHolders);
        this.store = store;
        this.commandCreationContext = commandCreationContext;
        this.ktx = ktx;
        this.tokenHolders = tokenHolders;
    }

    public int labelGetOrCreateForName(String labelName) throws KernelException {
        return this.getOrCreateForName(this.tokenHolders.labelTokens(), PrivilegeAction.CREATE_LABEL, labelName);
    }

    public void labelGetOrCreateForNames(String[] labelNames, int[] labelIds) throws KernelException {
        this.getOrCreateForNames(this.tokenHolders.labelTokens(), PrivilegeAction.CREATE_LABEL, labelNames, labelIds);
    }

    public int labelCreateForName(String labelName, boolean internal) throws KernelException {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        int id = KernelToken.reserveTokenId(() -> ((CommandCreationContext)this.commandCreationContext).reserveLabelTokenId(), this.tokenHolders.labelTokens());
        txState.labelDoCreateForName(labelName, internal, id);
        return id;
    }

    public int relationshipTypeCreateForName(String relationshipTypeName, boolean internal) throws KernelException {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        int id = KernelToken.reserveTokenId(() -> ((CommandCreationContext)this.commandCreationContext).reserveRelationshipTypeTokenId(), this.tokenHolders.relationshipTypeTokens());
        txState.relationshipTypeDoCreateForName(relationshipTypeName, internal, id);
        return id;
    }

    public int propertyKeyCreateForName(String propertyKeyName, boolean internal) throws KernelException {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        int id = KernelToken.reserveTokenId(() -> ((CommandCreationContext)this.commandCreationContext).reservePropertyKeyTokenId(), this.tokenHolders.propertyKeyTokens());
        txState.propertyKeyDoCreateForName(propertyKeyName, internal, id);
        return id;
    }

    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws KernelException {
        return this.getOrCreateForName(this.tokenHolders.propertyKeyTokens(), PrivilegeAction.CREATE_PROPERTYKEY, propertyKeyName);
    }

    public void propertyKeyGetOrCreateForNames(String[] propertyKeys, int[] ids) throws KernelException {
        this.getOrCreateForNames(this.tokenHolders.propertyKeyTokens(), PrivilegeAction.CREATE_PROPERTYKEY, propertyKeys, ids);
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws KernelException {
        return this.getOrCreateForName(this.tokenHolders.relationshipTypeTokens(), PrivilegeAction.CREATE_RELTYPE, relationshipTypeName);
    }

    public void relationshipTypeGetOrCreateForNames(String[] relationshipTypes, int[] ids) throws KernelException {
        this.getOrCreateForNames(this.tokenHolders.relationshipTypeTokens(), PrivilegeAction.CREATE_RELTYPE, relationshipTypes, ids);
    }

    @Override
    public int propertyKeyCount() {
        this.ktx.assertOpen();
        return this.store.propertyKeyCount();
    }

    @Override
    public int relationshipTypeCount() {
        this.ktx.assertOpen();
        return this.store.relationshipTypeCount();
    }

    @Override
    void performCheckBeforeOperation() {
        this.ktx.assertOpen();
    }

    @Override
    AccessMode getAccessMode() {
        return this.ktx.securityContext().mode();
    }

    private int getOrCreateForName(TokenHolder tokens, PrivilegeAction action, String name) throws KernelException {
        this.ktx.assertOpen();
        int id = tokens.getIdByName(TokenWrite.checkValidTokenName((String)name));
        if (id != -1) {
            return id;
        }
        this.ktx.securityAuthorizationHandler().assertAllowsTokenCreates(this.ktx.securityContext(), action);
        this.ktx.ensureValid();
        return tokens.getOrCreateId(name);
    }

    private void getOrCreateForNames(TokenHolder tokenHolder, PrivilegeAction action, String[] names, int[] ids) throws KernelException {
        this.ktx.assertOpen();
        KernelToken.assertSameLength(names, ids);
        for (int i = 0; i < names.length; ++i) {
            ids[i] = tokenHolder.getIdByName(TokenWrite.checkValidTokenName((String)names[i]));
            if (ids[i] != -1) continue;
            this.ktx.securityAuthorizationHandler().assertAllowsTokenCreates(this.ktx.securityContext(), action);
            this.ktx.ensureValid();
            tokenHolder.getOrCreateIds(names, ids);
            return;
        }
    }

    private static void assertSameLength(String[] names, int[] ids) {
        if (names.length != ids.length) {
            throw new IllegalArgumentException("Name and id arrays have different length.");
        }
    }

    private static int reserveTokenId(IntSupplier generator, TokenHolder holder) throws KernelException {
        try {
            int id;
            while (holder.hasToken(id = generator.getAsInt())) {
            }
            return id;
        }
        catch (IdCapacityExceededException e) {
            throw new TokenCapacityExceededKernelException((Throwable)e, holder.getTokenType());
        }
    }
}

