/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.nio.file.Files;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;

public class PackagingDiagnostics
extends NamedDiagnosticsProvider {
    public static final String PACKAGING_INFO_FILENAME = "packaging_info";
    private final Path home;

    PackagingDiagnostics(Config config) {
        super("Packaging");
        this.home = (Path)config.get(GraphDatabaseSettings.neo4j_home);
    }

    public void dump(DiagnosticsLogger logger) {
        Path packagingInfoPath = this.home.resolve(PACKAGING_INFO_FILENAME);
        try {
            for (String line : Files.readAllLines(packagingInfoPath)) {
                if (line.startsWith("Version:")) continue;
                logger.log(line);
            }
        }
        catch (Exception e) {
            logger.log("Could not read packaging info: %s".formatted(e));
        }
    }
}

