/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;

public class LogHeaderWriter {
    static final long LOG_VERSION_BITS = 56L;
    static final long LOG_VERSION_MASK = 0xFFFFFFFFFFFFFFL;

    private LogHeaderWriter() {
    }

    public static void writeLogHeader(StoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(128, ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            buffer.putLong(LogHeaderWriter.encodeLogVersion(logHeader.getLogVersion(), logHeader.getLogFormatVersion()));
            buffer.putLong(logHeader.getLastCommittedTxId());
            StoreIdSerialization.serializeWithFixedSize((StoreId)logHeader.getStoreId(), (ByteBuffer)buffer);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.flip();
            channel.writeAll(buffer);
        }
        channel.flush();
    }

    public static long encodeLogVersion(long logVersion, long formatVersion) {
        return logVersion & 0xFFFFFFFFFFFFFFL | formatVersion << 56;
    }
}

