/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.MultiPropertyConstraintDefinition;

abstract class RelationshipConstraintDefinition
extends MultiPropertyConstraintDefinition {
    protected final RelationshipType relationshipType;

    RelationshipConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, RelationshipType relationshipType, String propertyKey) {
        super(actions, constraint, new String[]{propertyKey});
        this.relationshipType = Objects.requireNonNull(relationshipType);
    }

    RelationshipConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, IndexDefinition indexDefinition) {
        super(actions, constraint, indexDefinition);
        if (indexDefinition.isMultiTokenIndex()) {
            throw new IllegalArgumentException("Relationship constraints do not support multi-token definitions. That is, they cannot apply to more than one relationship type, but an attempt was made to create a relationship constraint on the following relationship types: " + IndexDefinitionImpl.relTypeNameList(indexDefinition.getRelationshipTypes(), "", "."));
        }
        this.relationshipType = (RelationshipType)Iterables.single((Iterable)indexDefinition.getRelationshipTypes());
    }

    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("Constraint is associated with relationships");
    }

    public RelationshipType getRelationshipType() {
        this.assertInUnterminatedTransaction();
        return this.relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipConstraintDefinition that = (RelationshipConstraintDefinition)o;
        return this.relationshipType.name().equals(that.relationshipType.name()) && Arrays.equals(this.propertyKeys, that.propertyKeys);
    }

    @Override
    public int hashCode() {
        return 31 * this.relationshipType.name().hashCode() + Arrays.hashCode(this.propertyKeys);
    }
}

