/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.api.CloseableResourceManager;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.EntityLocker;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.internal.CursorIterator;
import org.neo4j.kernel.impl.coreapi.internal.NodeLabelPropertyIterator;
import org.neo4j.kernel.impl.coreapi.internal.RelationshipTypePropertyIterator;
import org.neo4j.kernel.impl.coreapi.internal.TrackedCursorIterator;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.FilteringNodeCursorWrapper;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.util.Preconditions;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class TransactionImpl
implements InternalTransaction {
    private final TokenHolders tokenHolders;
    private final TransactionalContextFactory contextFactory;
    private final DatabaseAvailabilityGuard availabilityGuard;
    private final QueryExecutionEngine executionEngine;
    private final Consumer<Status> terminationCallback;
    private final TransactionExceptionMapper exceptionMapper;
    private final ElementIdMapper elementIdMapper;
    private final ResourceTracker coreApiResourceTracker;
    private KernelTransaction transaction;
    private boolean closed;

    public TransactionImpl(TokenHolders tokenHolders, TransactionalContextFactory contextFactory, DatabaseAvailabilityGuard availabilityGuard, QueryExecutionEngine executionEngine, KernelTransaction transaction, ElementIdMapper elementIdMapper) {
        this(tokenHolders, contextFactory, availabilityGuard, executionEngine, transaction, new CloseableResourceManager(), null, null, elementIdMapper);
    }

    public TransactionImpl(TokenHolders tokenHolders, TransactionalContextFactory contextFactory, DatabaseAvailabilityGuard availabilityGuard, QueryExecutionEngine executionEngine, KernelTransaction transaction, ResourceTracker coreApiResourceTracker, Consumer<Status> terminationCallback, TransactionExceptionMapper exceptionMapper, ElementIdMapper elementIdMapper) {
        this.tokenHolders = tokenHolders;
        this.contextFactory = contextFactory;
        this.availabilityGuard = availabilityGuard;
        this.executionEngine = executionEngine;
        this.coreApiResourceTracker = coreApiResourceTracker;
        this.terminationCallback = terminationCallback;
        this.exceptionMapper = exceptionMapper;
        this.elementIdMapper = elementIdMapper;
        this.setTransaction(transaction);
    }

    public void registerCloseableResource(AutoCloseable closeableResource) {
        this.coreApiResourceTracker.registerCloseableResource(closeableResource);
    }

    public void unregisterCloseableResource(AutoCloseable closeableResource) {
        this.coreApiResourceTracker.unregisterCloseableResource(closeableResource);
    }

    public void commit() {
        this.commit(KernelTransaction.NO_MONITOR);
    }

    public void commit(KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor) {
        this.safeTerminalOperation(transaction -> transaction.commit(kernelTransactionMonitor));
    }

    public void rollback() {
        if (this.isOpen()) {
            this.safeTerminalOperation(KernelTransaction::rollback);
        }
    }

    public Node createNode() {
        KernelTransaction ktx = this.kernelTransaction();
        try {
            return this.newNodeEntity(ktx.dataWrite().nodeCreate());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node createNode(Label ... labels) {
        KernelTransaction ktx = this.kernelTransaction();
        try {
            TokenWrite tokenWrite = ktx.tokenWrite();
            int[] labelIds = new int[labels.length];
            String[] labelNames = new String[labels.length];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = labels[i].name();
            }
            tokenWrite.labelGetOrCreateForNames(labelNames, labelIds);
            Write write = ktx.dataWrite();
            long nodeId = write.nodeCreateWithLabels(labelIds);
            return this.newNodeEntity(nodeId);
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node getNodeById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, String.valueOf(id)));
        }
        KernelTransaction ktx = this.kernelTransaction();
        if (!ktx.dataRead().nodeExists(id)) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, String.valueOf(id)));
        }
        return this.newNodeEntity(id);
    }

    public Node getNodeByElementId(String elementId) {
        long nodeId;
        Read read = this.kernelTransaction().dataRead();
        if (!read.nodeExists(nodeId = this.elementIdMapper.nodeId(elementId))) {
            throw new NotFoundException(String.format("Node %s not found.", elementId), (Throwable)new EntityNotFoundException(EntityType.NODE, elementId));
        }
        return this.newNodeEntity(nodeId);
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        return this.execute(this, query, ValueUtils.asParameterMapValue(parameters));
    }

    private Result execute(InternalTransaction transaction, String query, MapValue parameters) throws QueryExecutionException {
        this.checkInTransaction();
        TransactionalContext context = this.contextFactory.newContext(transaction, query, parameters);
        try {
            this.availabilityGuard.assertDatabaseAvailable();
            return this.executionEngine.executeQuery(query, parameters, context, false);
        }
        catch (UnavailableException ue) {
            throw new TransactionFailureException(ue.getMessage(), (Throwable)ue);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Relationship with %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, String.valueOf(id)));
        }
        KernelTransaction ktx = this.kernelTransaction();
        if (!ktx.dataRead().relationshipExists(id)) {
            throw new NotFoundException(String.format("Relationship with %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, String.valueOf(id)));
        }
        return this.newRelationshipEntity(id);
    }

    public Relationship getRelationshipByElementId(String elementId) {
        long relationshipId;
        Read read = this.kernelTransaction().dataRead();
        if (!read.relationshipExists(relationshipId = this.elementIdMapper.relationshipId(elementId))) {
            throw new NotFoundException(String.format("Relationship %s not found.", elementId), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, elementId));
        }
        return this.newRelationshipEntity(relationshipId);
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        this.checkInTransaction();
        return new BidirectionalTraversalDescriptionImpl();
    }

    public TraversalDescription traversalDescription() {
        this.checkInTransaction();
        return new MonoDirectionalTraversalDescription();
    }

    public Iterable<Label> getAllLabelsInUse() {
        return this.allInUse(TokenAccess.LABELS);
    }

    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.allInUse(TokenAccess.RELATIONSHIP_TYPES);
    }

    public Iterable<Label> getAllLabels() {
        return this.all(TokenAccess.LABELS);
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.all(TokenAccess.RELATIONSHIP_TYPES);
    }

    public Iterable<String> getAllPropertyKeys() {
        return this.all(TokenAccess.PROPERTY_KEYS);
    }

    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple nodes with label: '%s', property name: '%s' and property value: '%s' while only one was expected.", myLabel, key, value));
            }
            Node node2 = node;
            return node2;
        }
    }

    public ResourceIterator<Node> findNodes(Label myLabel) {
        TransactionImpl.checkLabel(myLabel);
        return this.allNodesWithLabel(myLabel);
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        TransactionImpl.checkLabel(myLabel);
        TransactionImpl.checkPropertyKey(key);
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        if (TransactionImpl.invalidTokens(labelId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery.ExactPredicate query = PropertyIndexQuery.exact((int)propertyId, (Object)Values.of((Object)value, (boolean)false));
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId}), new IndexQuery[]{query});
        return this.nodesByLabelAndProperty(transaction, labelId, (PropertyIndexQuery)query, index);
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, String value, StringSearchMode searchMode) {
        TransactionImpl.checkLabel(myLabel);
        TransactionImpl.checkPropertyKey(key);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Template must not be null");
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        if (TransactionImpl.invalidTokens(labelId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery query = TransactionImpl.getIndexQuery(value, searchMode, propertyId);
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId}), IndexType.TEXT, new IndexQuery[]{query});
        if (index == IndexDescriptor.NO_INDEX && (searchMode == StringSearchMode.SUFFIX || searchMode == StringSearchMode.CONTAINS)) {
            PropertyIndexQuery.RangePredicate allStringQuery = PropertyIndexQuery.range((int)propertyId, (String)null, (boolean)false, null, (boolean)false);
            index = TransactionImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId}), new IndexQuery[]{allStringQuery});
            if (index != IndexDescriptor.NO_INDEX && index.getCapability().supportsReturningValues()) {
                return this.nodesByLabelAndPropertyWithFiltering(transaction, labelId, (PropertyIndexQuery)allStringQuery, index, query);
            }
        }
        return this.nodesByLabelAndProperty(transaction, labelId, query, index);
    }

    private static PropertyIndexQuery getIndexQuery(String value, StringSearchMode searchMode, int propertyId) {
        return switch (searchMode) {
            default -> throw new IncompatibleClassChangeError();
            case StringSearchMode.EXACT -> PropertyIndexQuery.exact((int)propertyId, (Object)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
            case StringSearchMode.PREFIX -> PropertyIndexQuery.stringPrefix((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
            case StringSearchMode.SUFFIX -> PropertyIndexQuery.stringSuffix((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
            case StringSearchMode.CONTAINS -> PropertyIndexQuery.stringContains((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
        };
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        TransactionImpl.checkLabel(label);
        TransactionImpl.checkPropertyKey(key1);
        TransactionImpl.checkPropertyKey(key2);
        TransactionImpl.checkPropertyKey(key3);
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(transaction, labelId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key3), (Object)Values.of((Object)value3, (boolean)false)));
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        TransactionImpl.checkLabel(label);
        TransactionImpl.checkPropertyKey(key1);
        TransactionImpl.checkPropertyKey(key2);
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(transaction, labelId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)));
    }

    public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        TransactionImpl.checkLabel(label);
        Preconditions.checkArgument((propertyValues != null ? 1 : 0) != 0, (String)"Property values can not be null");
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        PropertyIndexQuery.ExactPredicate[] queries = TransactionImpl.convertToQueries(propertyValues, tokenRead);
        return this.nodesByLabelAndProperties(transaction, labelId, queries);
    }

    public ResourceIterable<Node> getAllNodes() {
        this.checkInTransaction();
        return new TrackingResourceIterable<Node>(this, new NodesProvider());
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        this.checkInTransaction();
        return new TrackingResourceIterable<Relationship>(this, new RelationshipsProvider());
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key, String template, StringSearchMode searchMode) {
        TransactionImpl.checkRelationshipType(relationshipType);
        TransactionImpl.checkPropertyKey(key);
        Preconditions.checkArgument((template != null ? 1 : 0) != 0, (String)"Template must not be null");
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        int propertyId = tokenRead.propertyKey(key);
        if (TransactionImpl.invalidTokens(typeId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery query = TransactionImpl.getIndexQuery(template, searchMode, propertyId);
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])new int[]{propertyId}), IndexType.TEXT, new IndexQuery[]{query});
        if (index == IndexDescriptor.NO_INDEX && (searchMode == StringSearchMode.SUFFIX || searchMode == StringSearchMode.CONTAINS)) {
            PropertyIndexQuery.RangePredicate allStringQuery = PropertyIndexQuery.range((int)propertyId, (String)null, (boolean)false, null, (boolean)false);
            index = TransactionImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])new int[]{propertyId}), new IndexQuery[]{allStringQuery});
            if (index != IndexDescriptor.NO_INDEX && index.getCapability().supportsReturningValues()) {
                return this.relationshipsByTypeAndPropertyWithFiltering(transaction, typeId, (PropertyIndexQuery)allStringQuery, index, query);
            }
        }
        return this.relationshipsByTypeAndProperty(transaction, typeId, query, index);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, Map<String, Object> propertyValues) {
        TransactionImpl.checkRelationshipType(relationshipType);
        Preconditions.checkArgument((propertyValues != null ? 1 : 0) != 0, (String)"Property values can not be null");
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        PropertyIndexQuery.ExactPredicate[] queries = TransactionImpl.convertToQueries(propertyValues, tokenRead);
        return this.relationshipsByTypeAndProperties(transaction, typeId, queries);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        TransactionImpl.checkRelationshipType(relationshipType);
        TransactionImpl.checkPropertyKey(key1);
        TransactionImpl.checkPropertyKey(key2);
        TransactionImpl.checkPropertyKey(key3);
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        return this.relationshipsByTypeAndProperties(transaction, typeId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key3), (Object)Values.of((Object)value3, (boolean)false)));
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key1, Object value1, String key2, Object value2) {
        TransactionImpl.checkRelationshipType(relationshipType);
        TransactionImpl.checkPropertyKey(key1);
        TransactionImpl.checkPropertyKey(key2);
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        return this.relationshipsByTypeAndProperties(transaction, typeId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)));
    }

    public Relationship findRelationship(RelationshipType relationshipType, String key, Object value) {
        try (ResourceIterator<Relationship> iterator = this.findRelationships(relationshipType, key, value);){
            if (!iterator.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple relationships with type: '%s', property name: '%s' and property value: '%s' while only one was expected.", relationshipType, key, value));
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key, Object value) {
        TransactionImpl.checkRelationshipType(relationshipType);
        TransactionImpl.checkPropertyKey(key);
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        int propertyId = tokenRead.propertyKey(key);
        if (TransactionImpl.invalidTokens(typeId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery.ExactPredicate query = PropertyIndexQuery.exact((int)propertyId, (Object)Values.of((Object)value, (boolean)false));
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])new int[]{propertyId}), new IndexQuery[]{query});
        return this.relationshipsByTypeAndProperty(transaction, typeId, (PropertyIndexQuery)query, index);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType) {
        TransactionImpl.checkRelationshipType(relationshipType);
        return this.allRelationshipsWithType(relationshipType);
    }

    public final void terminate() {
        this.terminate((Status)Status.Transaction.Terminated);
    }

    public void terminate(Status reason) {
        KernelTransaction ktx = this.transaction;
        if (ktx == null) {
            return;
        }
        ktx.markForTermination(reason);
        if (this.terminationCallback != null) {
            this.terminationCallback.accept(reason);
        }
    }

    public UUID getDatabaseId() {
        if (this.transaction != null) {
            return this.transaction.getDatabaseId();
        }
        return null;
    }

    public String getDatabaseName() {
        if (this.transaction != null) {
            return this.transaction.getDatabaseName();
        }
        return null;
    }

    public void close() {
        if (this.isOpen()) {
            this.safeTerminalOperation(tx -> {});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeTerminalOperation(TransactionalOperation operation) {
        if (this.closed) {
            assert (this.transaction == null) : "Closed but still have reference to kernel transaction";
            throw this.exceptionMapper.mapException((Exception)((Object)new NotInTransactionException("The transaction has been closed.")));
        }
        Exception exception = null;
        try {
            try {
                this.coreApiResourceTracker.closeAllCloseableResources();
                operation.perform(this.transaction);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                if (this.transaction != null) {
                    this.transaction.close();
                }
            }
        }
        catch (Exception e) {
            exception = (Exception)Exceptions.chain((Throwable)exception, (Throwable)e);
        }
        finally {
            this.closed = true;
            this.transaction = null;
        }
        if (exception != null) {
            throw this.exceptionMapper.mapException(exception);
        }
    }

    public void setTransaction(KernelTransaction transaction) {
        this.transaction = transaction;
        transaction.bindToUserTransaction((InternalTransaction)this);
    }

    public Lock acquireWriteLock(Entity entity) {
        return EntityLocker.exclusiveLock(this.kernelTransaction(), entity);
    }

    public Lock acquireReadLock(Entity entity) {
        return EntityLocker.sharedLock(this.kernelTransaction(), entity);
    }

    public KernelTransaction kernelTransaction() {
        this.checkInTransaction();
        return this.transaction;
    }

    public KernelTransaction.Type transactionType() {
        return this.kernelTransaction().transactionType();
    }

    public SecurityContext securityContext() {
        return this.kernelTransaction().securityContext();
    }

    public ClientConnectionInfo clientInfo() {
        return this.kernelTransaction().clientInfo();
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.kernelTransaction().overrideWith(context);
    }

    public Optional<Status> terminationReason() {
        KernelTransaction tx = this.transaction;
        return tx != null ? tx.getReasonIfTerminated() : Optional.empty();
    }

    public void setMetaData(Map<String, Object> txMeta) {
        this.kernelTransaction().setMetaData(txMeta);
    }

    public RelationshipEntity newRelationshipEntity(long id) {
        return new RelationshipEntity((InternalTransaction)this, id);
    }

    public Relationship newRelationshipEntity(String elementId) {
        return new RelationshipEntity((InternalTransaction)this, this.elementIdMapper.relationshipId(elementId));
    }

    public RelationshipEntity newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipEntity(this, id, startNodeId, typeId, endNodeId);
    }

    public Relationship newRelationshipEntity(RelationshipDataAccessor cursor) {
        return new RelationshipEntity((InternalTransaction)this, cursor);
    }

    public NodeEntity newNodeEntity(long nodeId) {
        return new NodeEntity(this, nodeId);
    }

    public RelationshipType getRelationshipTypeById(int type) {
        try {
            String name = this.tokenHolders.relationshipTypeTokens().getTokenById(type).name();
            return RelationshipType.withName((String)name);
        }
        catch (TokenNotFoundException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type, e);
        }
    }

    public Schema schema() {
        return new SchemaImpl(this.kernelTransaction());
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(KernelTransaction transaction, int labelId, PropertyIndexQuery query, IndexDescriptor index) {
        Read read = transaction.dataRead();
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.nodeIndexSeek(transaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
                return new TrackedCursorIterator<NodeValueIndexCursor, Node>(cursor, NodeIndexCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.coreApiResourceTracker);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutPropertyIndex(transaction, labelId, query);
    }

    private ResourceIterator<Node> nodesByLabelAndPropertyWithFiltering(KernelTransaction transaction, int labelId, PropertyIndexQuery query, IndexDescriptor index, PropertyIndexQuery originalQuery) {
        Read read = transaction.dataRead();
        try {
            NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());
            IndexReadSession indexSession = read.indexReadSession(index);
            read.nodeIndexSeek(transaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{query});
            return new TrackedCursorIterator<FilteringCursor, Node>(new FilteringCursor<NodeValueIndexCursor>(cursor, originalQuery), c -> cursor.nodeReference(), c -> this.newNodeEntity(cursor.nodeReference()), this.coreApiResourceTracker);
        }
        catch (KernelException kernelException) {
            return this.getNodesByLabelAndPropertyWithoutPropertyIndex(transaction, labelId, query);
        }
    }

    public Entity validateSameDB(Entity entity) {
        InternalTransaction internalTransaction;
        if (entity instanceof NodeEntity) {
            NodeEntity node = (NodeEntity)entity;
            internalTransaction = node.getTransaction();
        } else if (entity instanceof RelationshipEntity) {
            RelationshipEntity rel = (RelationshipEntity)entity;
            internalTransaction = rel.getTransaction();
        } else {
            return entity;
        }
        if (!internalTransaction.isOpen()) {
            throw new NotInTransactionException("The transaction of entity " + entity.getElementId() + " has been closed.");
        }
        if (internalTransaction.getDatabaseId() != this.getDatabaseId()) {
            throw new CypherExecutionException("Can not use an entity from another database. Entity element id: " + entity.getElementId() + ", entity database: " + internalTransaction.getDatabaseName() + ", expected database: " + this.getDatabaseName() + ".");
        }
        return entity;
    }

    private ResourceIterator<Relationship> relationshipsByTypeAndProperty(KernelTransaction transaction, int typeId, PropertyIndexQuery query, IndexDescriptor index) {
        Read read = transaction.dataRead();
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.relationshipIndexSeek(transaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
                return new TrackedCursorIterator<RelationshipValueIndexCursor, Relationship>(cursor, RelationshipDataAccessor::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference()), this.coreApiResourceTracker);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getRelationshipsByTypeAndPropertyWithoutPropertyIndex(transaction, typeId, query);
    }

    private ResourceIterator<Relationship> relationshipsByTypeAndPropertyWithFiltering(KernelTransaction transaction, int typeId, PropertyIndexQuery query, IndexDescriptor index, PropertyIndexQuery originalQuery) {
        Read read = transaction.dataRead();
        try {
            RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());
            IndexReadSession indexSession = read.indexReadSession(index);
            read.relationshipIndexSeek(transaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{query});
            return new TrackedCursorIterator<FilteringCursor, Relationship>(new FilteringCursor<RelationshipValueIndexCursor>(cursor, originalQuery), value -> cursor.relationshipReference(), c -> this.newRelationshipEntity(cursor.relationshipReference()), this.coreApiResourceTracker);
        }
        catch (KernelException kernelException) {
            return this.getRelationshipsByTypeAndPropertyWithoutPropertyIndex(transaction, typeId, query);
        }
    }

    public void checkInTransaction() {
        if (this.closed) {
            throw new NotInTransactionException("The transaction has been closed.");
        }
        if (this.transaction.isTerminated()) {
            Status terminationReason = (Status)this.transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public ElementIdMapper elementIdMapper() {
        return this.elementIdMapper;
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutPropertyIndex(KernelTransaction ktx, int labelId, PropertyIndexQuery ... queries) {
        TokenPredicate tokenQuery = new TokenPredicate(labelId);
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(ktx, (SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), new IndexQuery[]{tokenQuery});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = ktx.dataRead().tokenReadSession(index);
                NodeLabelIndexCursor cursor = ktx.cursors().allocateNodeLabelIndexCursor(ktx.cursorContext());
                ktx.dataRead().nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), tokenQuery, ktx.cursorContext());
                NodeCursor nodeCursor = ktx.cursors().allocateNodeCursor(ktx.cursorContext());
                PropertyCursor propertyCursor = ktx.cursors().allocatePropertyCursor(ktx.cursorContext(), ktx.memoryTracker());
                return new NodeLabelPropertyIterator(ktx.dataRead(), cursor, nodeCursor, propertyCursor, c -> this.newNodeEntity(c.nodeReference()), this.coreApiResourceTracker, queries);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyViaAllNodesScan(ktx, labelId, queries);
    }

    private TrackedCursorIterator<FilteringNodeCursorWrapper, Node> getNodesByLabelAndPropertyViaAllNodesScan(KernelTransaction ktx, int labelId, PropertyIndexQuery[] queries) {
        NodeCursor nodeCursor = ktx.cursors().allocateNodeCursor(ktx.cursorContext());
        FilteringNodeCursorWrapper labelFilteredCursor = new FilteringNodeCursorWrapper(nodeCursor, CursorPredicates.hasLabel(labelId));
        PropertyCursor propertyCursor = ktx.cursors().allocatePropertyCursor(ktx.cursorContext(), ktx.memoryTracker());
        FilteringNodeCursorWrapper propertyFilteredCursor = new FilteringNodeCursorWrapper(labelFilteredCursor, CursorPredicates.nodeMatchProperties(queries, propertyCursor), List.of(propertyCursor));
        ktx.dataRead().allNodesScan(nodeCursor);
        return new TrackedCursorIterator<FilteringNodeCursorWrapper, Node>(propertyFilteredCursor, NodeCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.coreApiResourceTracker);
    }

    private ResourceIterator<Relationship> getRelationshipsByTypeAndPropertyWithoutPropertyIndex(KernelTransaction ktx, int typeId, PropertyIndexQuery ... queries) {
        TokenPredicate tokenQuery = new TokenPredicate(typeId);
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(ktx, (SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP), new IndexQuery[]{tokenQuery});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = ktx.dataRead().tokenReadSession(index);
                RelationshipTypeIndexCursor cursor = ktx.cursors().allocateRelationshipTypeIndexCursor(ktx.cursorContext());
                ktx.dataRead().relationshipTypeScan(session, cursor, IndexQueryConstraints.unconstrained(), tokenQuery, ktx.cursorContext());
                RelationshipScanCursor relationshipScanCursor = ktx.cursors().allocateRelationshipScanCursor(ktx.cursorContext());
                PropertyCursor propertyCursor = ktx.cursors().allocatePropertyCursor(ktx.cursorContext(), ktx.memoryTracker());
                return new RelationshipTypePropertyIterator(ktx.dataRead(), cursor, relationshipScanCursor, propertyCursor, c -> this.newRelationshipEntity(c.relationshipReference()), this.coreApiResourceTracker, queries);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getRelationshipsByTypeAndPropertyViaAllRelsScan(ktx, typeId, queries);
    }

    private ResourceIterator<Relationship> getRelationshipsByTypeAndPropertyViaAllRelsScan(KernelTransaction ktx, int typeId, PropertyIndexQuery[] queries) {
        RelationshipScanCursor relationshipScanCursor = ktx.cursors().allocateRelationshipScanCursor(ktx.cursorContext());
        FilteringRelationshipScanCursorWrapper typeFiltered = new FilteringRelationshipScanCursorWrapper(relationshipScanCursor, CursorPredicates.hasType(typeId));
        PropertyCursor propertyCursor = ktx.cursors().allocatePropertyCursor(ktx.cursorContext(), ktx.memoryTracker());
        FilteringRelationshipScanCursorWrapper propertyFilteredCursor = new FilteringRelationshipScanCursorWrapper(typeFiltered, CursorPredicates.relationshipMatchProperties(queries, propertyCursor), List.of(propertyCursor));
        ktx.dataRead().allRelationshipsScan(relationshipScanCursor);
        return new TrackedCursorIterator<FilteringRelationshipScanCursorWrapper, Relationship>(propertyFilteredCursor, RelationshipDataAccessor::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference(), c.sourceNodeReference(), c.type(), c.targetNodeReference()), this.coreApiResourceTracker);
    }

    private ResourceIterator<Node> nodesByLabelAndProperties(KernelTransaction transaction, int labelId, PropertyIndexQuery.ExactPredicate ... queries) {
        Read read = transaction.dataRead();
        if (TransactionImpl.isInvalidQuery(labelId, (PropertyIndexQuery[])queries)) {
            return Iterators.emptyResourceIterator();
        }
        int[] propertyIds = TransactionImpl.getPropertyIds((PropertyIndexQuery[])queries);
        IndexDescriptor index = TransactionImpl.findUsableMatchingCompositeIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds), propertyIds, () -> transaction.schemaRead().indexesGetForLabel(labelId), (IndexQuery[])queries);
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.nodeIndexSeek(transaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), TransactionImpl.getReorderedIndexQueries(index.schema().getPropertyIds(), (PropertyIndexQuery[])queries));
                return new TrackedCursorIterator<NodeValueIndexCursor, Node>(cursor, NodeIndexCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.coreApiResourceTracker);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutPropertyIndex(transaction, labelId, (PropertyIndexQuery[])queries);
    }

    private static PropertyIndexQuery[] getReorderedIndexQueries(int[] indexPropertyIds, PropertyIndexQuery[] queries) {
        PropertyIndexQuery[] orderedQueries = new PropertyIndexQuery[queries.length];
        block0: for (int i = 0; i < indexPropertyIds.length; ++i) {
            int propertyKeyId = indexPropertyIds[i];
            for (PropertyIndexQuery query : queries) {
                if (query.propertyKeyId() != propertyKeyId) continue;
                orderedQueries[i] = query;
                continue block0;
            }
        }
        return orderedQueries;
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        KernelTransaction ktx = this.kernelTransaction();
        int labelId = ktx.tokenRead().nodeLabel(myLabel.name());
        if (labelId == -1) {
            return Iterators.emptyResourceIterator();
        }
        TokenPredicate query = new TokenPredicate(labelId);
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(ktx, (SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), new IndexQuery[]{query});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = ktx.dataRead().tokenReadSession(index);
                NodeLabelIndexCursor cursor = ktx.cursors().allocateNodeLabelIndexCursor(ktx.cursorContext());
                ktx.dataRead().nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), query, ktx.cursorContext());
                return new TrackedCursorIterator<NodeLabelIndexCursor, Node>(cursor, NodeIndexCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.coreApiResourceTracker);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.allNodesByLabelWithoutIndex(ktx, labelId);
    }

    private ResourceIterator<Node> allNodesByLabelWithoutIndex(KernelTransaction ktx, int labelId) {
        NodeCursor cursor = ktx.cursors().allocateNodeCursor(ktx.cursorContext());
        ktx.dataRead().allNodesScan(cursor);
        FilteringNodeCursorWrapper filetredCursor = new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(labelId));
        return new TrackedCursorIterator<FilteringNodeCursorWrapper, Node>(filetredCursor, NodeCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.coreApiResourceTracker);
    }

    private ResourceIterator<Relationship> allRelationshipsWithType(RelationshipType type) {
        KernelTransaction ktx = this.kernelTransaction();
        int typeId = ktx.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return Iterators.emptyResourceIterator();
        }
        TokenPredicate query = new TokenPredicate(typeId);
        IndexDescriptor index = TransactionImpl.findUsableMatchingIndex(ktx, (SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP), new IndexQuery[]{query});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = ktx.dataRead().tokenReadSession(index);
                RelationshipTypeIndexCursor cursor = ktx.cursors().allocateRelationshipTypeIndexCursor(ktx.cursorContext());
                ktx.dataRead().relationshipTypeScan(session, cursor, IndexQueryConstraints.unconstrained(), query, ktx.cursorContext());
                return new TrackedCursorIterator<RelationshipTypeIndexCursor, Relationship>(cursor, RelationshipDataAccessor::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference()), this.coreApiResourceTracker);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.allRelationshipsByTypeWithoutIndex(ktx, typeId);
    }

    private ResourceIterator<Relationship> allRelationshipsByTypeWithoutIndex(KernelTransaction ktx, int typeId) {
        RelationshipScanCursor cursor = ktx.cursors().allocateRelationshipScanCursor(ktx.cursorContext());
        ktx.dataRead().allRelationshipsScan(cursor);
        FilteringRelationshipScanCursorWrapper filteredCursor = new FilteringRelationshipScanCursorWrapper(cursor, CursorPredicates.hasType(typeId));
        return new TrackedCursorIterator<FilteringRelationshipScanCursorWrapper, Relationship>(filteredCursor, RelationshipDataAccessor::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference(), c.sourceNodeReference(), c.type(), c.targetNodeReference()), this.coreApiResourceTracker);
    }

    private ResourceIterator<Relationship> relationshipsByTypeAndProperties(KernelTransaction tx, int typeId, PropertyIndexQuery.ExactPredicate ... queries) {
        Read read = tx.dataRead();
        if (TransactionImpl.isInvalidQuery(typeId, (PropertyIndexQuery[])queries)) {
            return Iterators.emptyResourceIterator();
        }
        int[] propertyIds = TransactionImpl.getPropertyIds((PropertyIndexQuery[])queries);
        IndexDescriptor index = TransactionImpl.findUsableMatchingCompositeIndex(tx, (SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])propertyIds), propertyIds, () -> tx.schemaRead().indexesGetForRelationshipType(typeId), (IndexQuery[])queries);
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                RelationshipValueIndexCursor cursor = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.relationshipIndexSeek(this.transaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), TransactionImpl.getReorderedIndexQueries(index.schema().getPropertyIds(), (PropertyIndexQuery[])queries));
                return new TrackedCursorIterator<RelationshipValueIndexCursor, Relationship>(cursor, RelationshipDataAccessor::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference()), this.coreApiResourceTracker);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getRelationshipsByTypeAndPropertyWithoutPropertyIndex(tx, typeId, (PropertyIndexQuery[])queries);
    }

    private static PropertyIndexQuery.ExactPredicate[] convertToQueries(Map<String, Object> propertyValues, TokenRead tokenRead) {
        PropertyIndexQuery.ExactPredicate[] queries = new PropertyIndexQuery.ExactPredicate[propertyValues.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            queries[i++] = PropertyIndexQuery.exact((int)tokenRead.propertyKey(entry.getKey()), (Object)Values.of((Object)entry.getValue(), (boolean)false));
        }
        return queries;
    }

    private static IndexDescriptor findUsableMatchingCompositeIndex(KernelTransaction transaction, SchemaDescriptor schemaDescriptor, int[] propertyIds, Supplier<Iterator<IndexDescriptor>> indexesSupplier, IndexQuery ... query) {
        IndexDescriptor directMatch = TransactionImpl.findUsableMatchingIndex(transaction, schemaDescriptor, query);
        if (directMatch != IndexDescriptor.NO_INDEX) {
            return directMatch;
        }
        Arrays.sort(propertyIds);
        TransactionImpl.assertNoDuplicates(propertyIds, transaction.tokenRead());
        int[] workingCopy = new int[propertyIds.length];
        Iterator<IndexDescriptor> indexes = indexesSupplier.get();
        while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            int[] original = index.schema().getPropertyIds();
            if (!TransactionImpl.hasSamePropertyIds(original, workingCopy, propertyIds) || !TransactionImpl.indexIsOnline(transaction.schemaRead(), index) || !TransactionImpl.indexSupportQuery(index, query)) continue;
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    private static IndexDescriptor findUsableMatchingIndex(KernelTransaction transaction, SchemaDescriptor schemaDescriptor, IndexQuery ... query) {
        return (IndexDescriptor)Iterators.firstOrDefault(TransactionImpl.getMatchingOnlineIndexes(transaction, schemaDescriptor, query), (Object)IndexDescriptor.NO_INDEX);
    }

    private static IndexDescriptor findUsableMatchingIndex(KernelTransaction transaction, SchemaDescriptor schemaDescriptor, IndexType preference, IndexQuery ... query) {
        List indexes = Iterators.asList(TransactionImpl.getMatchingOnlineIndexes(transaction, schemaDescriptor, query));
        Optional<IndexDescriptor> preferred = indexes.stream().filter(index -> index.getIndexType() == preference).findAny();
        return preferred.orElse((IndexDescriptor)Iterators.firstOrDefault(indexes.iterator(), (Object)IndexDescriptor.NO_INDEX));
    }

    private static Iterator<IndexDescriptor> getMatchingOnlineIndexes(KernelTransaction transaction, SchemaDescriptor schemaDescriptor, IndexQuery ... query) {
        SchemaRead schemaRead = transaction.schemaRead();
        Iterator iterator = schemaRead.index(schemaDescriptor);
        return Iterators.filter(index -> TransactionImpl.indexIsOnline(schemaRead, index) && TransactionImpl.indexSupportQuery(index, query), (Iterator)iterator);
    }

    private static boolean indexSupportQuery(IndexDescriptor index, IndexQuery[] query) {
        return Arrays.stream(query).allMatch(q -> index.getCapability().isQuerySupported(q.type(), q.valueCategory()));
    }

    private static boolean invalidTokens(int ... tokens) {
        return Arrays.stream(tokens).anyMatch(token -> token == -1);
    }

    private static boolean indexIsOnline(SchemaRead schemaRead, IndexDescriptor index) {
        InternalIndexState state = InternalIndexState.FAILED;
        try {
            state = schemaRead.indexGetState(index);
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
        return state == InternalIndexState.ONLINE;
    }

    private static void assertNoDuplicates(int[] propertyIds, TokenRead tokenRead) {
        int prev = propertyIds[0];
        for (int i = 1; i < propertyIds.length; ++i) {
            int curr = propertyIds[i];
            if (curr == prev) {
                throw new IllegalArgumentException(String.format("Provided two queries for property %s. Only one query per property key can be performed", tokenRead.propertyKeyGetName(curr)));
            }
            prev = curr;
        }
    }

    private static boolean hasSamePropertyIds(int[] original, int[] workingCopy, int[] propertyIds) {
        if (original.length == propertyIds.length) {
            System.arraycopy(original, 0, workingCopy, 0, original.length);
            Arrays.sort(workingCopy);
            return Arrays.equals(propertyIds, workingCopy);
        }
        return false;
    }

    private static int[] getPropertyIds(PropertyIndexQuery[] queries) {
        int[] propertyIds = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            propertyIds[i] = queries[i].propertyKeyId();
        }
        return propertyIds;
    }

    private static boolean isInvalidQuery(int tokenId, PropertyIndexQuery[] queries) {
        if (tokenId == -1) {
            return true;
        }
        return Arrays.stream(queries).mapToInt(PropertyIndexQuery::propertyKeyId).anyMatch(propertyKeyId -> propertyKeyId == -1);
    }

    private <T> Iterable<T> allInUse(TokenAccess<T> tokens) {
        KernelTransaction transaction = this.kernelTransaction();
        return () -> tokens.inUse(transaction);
    }

    private <T> Iterable<T> all(TokenAccess<T> tokens) {
        KernelTransaction transaction = this.kernelTransaction();
        return () -> tokens.all(transaction);
    }

    private static void checkPropertyKey(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"Property key can not be null");
    }

    private static void checkLabel(Label label) {
        Preconditions.checkArgument((label != null ? 1 : 0) != 0, (String)"Label can not be null");
    }

    private static void checkRelationshipType(RelationshipType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Relationship type can not be null");
    }

    @FunctionalInterface
    private static interface TransactionalOperation {
        public void perform(KernelTransaction var1) throws Exception;
    }

    private static class TrackingResourceIterable<T>
    extends AbstractResourceIterable<T> {
        private final TransactionImpl transaction;
        private final Function<TransactionImpl, ResourceIterator<T>> cursorProvider;

        private TrackingResourceIterable(TransactionImpl transaction, Function<TransactionImpl, ResourceIterator<T>> cursorProvider) {
            this.transaction = transaction;
            this.cursorProvider = cursorProvider;
            transaction.registerCloseableResource((AutoCloseable)((Object)this));
        }

        protected ResourceIterator<T> newIterator() {
            return this.cursorProvider.apply(this.transaction);
        }

        protected void onClosed() {
            this.transaction.unregisterCloseableResource((AutoCloseable)((Object)this));
        }
    }

    private static class NodesProvider
    implements Function<TransactionImpl, ResourceIterator<Node>> {
        private NodesProvider() {
        }

        @Override
        public ResourceIterator<Node> apply(TransactionImpl tx) {
            KernelTransaction ktx = tx.transaction;
            NodeCursor cursor = ktx.cursors().allocateNodeCursor(ktx.cursorContext());
            ktx.dataRead().allNodesScan(cursor);
            return new CursorIterator<NodeCursor, Node>(cursor, NodeCursor::nodeReference, c -> tx.newNodeEntity(c.nodeReference()));
        }
    }

    private static class RelationshipsProvider
    implements Function<TransactionImpl, ResourceIterator<Relationship>> {
        private RelationshipsProvider() {
        }

        @Override
        public ResourceIterator<Relationship> apply(TransactionImpl tx) {
            KernelTransaction ktx = tx.transaction;
            RelationshipScanCursor cursor = ktx.cursors().allocateRelationshipScanCursor(ktx.cursorContext());
            ktx.dataRead().allRelationshipsScan(cursor);
            return new CursorIterator<RelationshipScanCursor, Relationship>(cursor, RelationshipDataAccessor::relationshipReference, c -> tx.newRelationshipEntity((RelationshipDataAccessor)cursor));
        }
    }

    private static class FilteringCursor<CURSOR extends Cursor & ValueIndexCursor>
    implements Cursor {
        private final CURSOR originalCursor;
        private final PropertyIndexQuery filteringQuery;

        public FilteringCursor(CURSOR originalCursor, PropertyIndexQuery filteringQuery) {
            this.originalCursor = originalCursor;
            this.filteringQuery = filteringQuery;
        }

        public void close() {
            this.originalCursor.close();
        }

        public void closeInternal() {
            this.originalCursor.closeInternal();
        }

        public boolean isClosed() {
            return this.originalCursor.isClosed();
        }

        public void setCloseListener(CloseListener closeListener) {
            this.originalCursor.setCloseListener(closeListener);
        }

        public void setToken(int token) {
            this.originalCursor.setToken(token);
        }

        public int getToken() {
            return this.originalCursor.getToken();
        }

        public boolean next() {
            boolean acceptsValue;
            boolean next;
            do {
                boolean bl = acceptsValue = (next = this.originalCursor.next()) && this.filteringQuery.acceptsValue(((ValueIndexCursor)this.originalCursor).propertyValue(0));
            } while (next && !acceptsValue);
            return next;
        }

        public void setTracer(KernelReadTracer tracer) {
            this.originalCursor.setTracer(tracer);
        }

        public void removeTracer() {
            this.originalCursor.removeTracer();
        }
    }
}

