/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.monitor;

import java.util.Set;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public abstract class TransactionMonitor
implements Runnable {
    private final SystemNanoClock clock;
    private final InternalLog log;

    public TransactionMonitor(SystemNanoClock clock, LogService logService) {
        this.clock = clock;
        this.log = logService.getInternalLog(TransactionMonitor.class);
    }

    @Override
    public void run() {
        long nowNanos = this.clock.nanos();
        Set<MonitoredTransaction> activeTransactions = this.getActiveTransactions();
        this.checkExpiredTransactions(activeTransactions, nowNanos);
    }

    protected abstract Set<MonitoredTransaction> getActiveTransactions();

    private void checkExpiredTransactions(Set<MonitoredTransaction> activeTransactions, long nowNanos) {
        for (MonitoredTransaction activeTransaction : activeTransactions) {
            long transactionTimeoutNanos = activeTransaction.timeoutNanos();
            if (transactionTimeoutNanos <= 0L || !TransactionMonitor.isTransactionExpired(activeTransaction, nowNanos, transactionTimeoutNanos) || activeTransaction.isSchemaTransaction() || !activeTransaction.markForTermination((Status)Status.Transaction.TransactionTimedOut)) continue;
            this.log.warn("Transaction %s timeout.", new Object[]{activeTransaction.getIdentifyingDescription()});
        }
    }

    private static boolean isTransactionExpired(MonitoredTransaction activeTransaction, long nowNanos, long transactionTimeoutNanos) {
        return nowNanos - activeTransaction.startTimeNanos() > transactionTimeoutNanos;
    }

    public static interface MonitoredTransaction {
        public long startTimeNanos();

        public long timeoutNanos();

        public boolean isSchemaTransaction();

        public boolean markForTermination(Status var1);

        public String getIdentifyingDescription();
    }
}

