/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.function.UnaryOperator;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.values.storable.Value;

public class IndexMapReference
implements IndexMapSnapshotProvider {
    private volatile IndexMap indexMap = new IndexMap();

    @Override
    public IndexMap indexMapSnapshot() {
        return new IndexMap(this.indexMap);
    }

    public synchronized void modify(UnaryOperator<IndexMap> modifier) {
        IndexMap snapshot = this.indexMapSnapshot();
        this.indexMap = (IndexMap)modifier.apply(snapshot);
    }

    public IndexProxy getIndexProxy(IndexDescriptor index) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(index);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for index " + index + " exists.");
        }
        return proxy;
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(indexId);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for index id " + indexId + " exists.");
        }
        return proxy;
    }

    Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexMap.getAllIndexProxies();
    }

    IndexUpdaterMap createIndexUpdaterMap(IndexUpdateMode mode, boolean parallel) {
        return new IndexUpdaterMap(this.indexMap, mode, parallel);
    }

    public void validateBeforeCommit(IndexDescriptor index, Value[] tuple, long entityId) {
        IndexProxy proxy = this.indexMap.getIndexProxy(index);
        if (proxy != null) {
            proxy.validateBeforeCommit(tuple, entityId);
        }
    }
}

