/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.LocalConfig;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnspecifiedKernelException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.InnerTransactionHandlerImpl;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.RestrictedSchemaWrite;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionMemoryPool;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextCursorTracer;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionContext;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.KernelTokenRead;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.TransactionListenersState;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder,
ExecutionStatistics {
    private static final long NOT_COMMITTED_TRANSACTION_ID = -1L;
    private static final long NOT_COMMITTED_TRANSACTION_COMMIT_TIME = -1L;
    private static final String TRANSACTION_TAG = "transaction";
    private final CollectionsFactory collectionsFactory;
    private final DatabaseTransactionEventListeners eventListeners;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StorageEngine storageEngine;
    private final TransactionTracer transactionTracer;
    private final Pool<KernelTransactionImplementation> pool;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final TransactionExecutionMonitor transactionExecutionMonitor;
    private final LeaseService leaseService;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final NamedDatabaseId namedDatabaseId;
    private final TransactionClockContext clocks;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final ConstraintSemantics constraintSemantics;
    private final TransactionMemoryPool transactionMemoryPool;
    private CursorContext cursorContext;
    private final CursorContextFactory contextFactory;
    private final DatabaseReadOnlyChecker readOnlyDatabaseChecker;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private TxState txState;
    private volatile TransactionWriteState writeState;
    private AccessCapability accessCapability;
    private final KernelStatement currentStatement;
    private OverridableSecurityContext overridableSecurityContext;
    private final Locks.Client lockClient;
    private volatile long transactionSequenceNumber;
    private LeaseClient leaseClient;
    private volatile boolean closing;
    private volatile boolean closed;
    private boolean failure;
    private boolean success;
    private volatile Status terminationReason;
    private long startTimeMillis;
    private volatile long startTimeNanos;
    private volatile long timeoutMillis;
    private long lastTransactionIdWhenStarted;
    private final Statistics statistics;
    private TransactionEvent transactionEvent;
    private KernelTransaction.Type type;
    private long transactionId;
    private long commitTime;
    private volatile ClientConnectionInfo clientInfo;
    private volatile Map<String, Object> userMetaData;
    private volatile String statusDetails;
    private final AllStoreHolder allStoreHolder;
    private final Operations operations;
    private InternalTransaction internalTransaction;
    private volatile TraceProvider traceProvider;
    private volatile TransactionInitializationTrace initializationTrace;
    private final MemoryTracker memoryTracker;
    private final LocalConfig config;
    private volatile long transactionHeapBytesLimit;
    private final ExecutionContextFactory executionContextFactory;
    private final Lock terminationReleaseLock = new ReentrantLock();
    private KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor;
    private final StoreCursors transactionalCursors;
    private final KernelTransactions kernelTransactions;
    private volatile InnerTransactionHandlerImpl innerTransactionHandler;

    public KernelTransactionImplementation(Config externalConfig, DatabaseTransactionEventListeners eventListeners, ConstraintIndexCreator constraintIndexCreator, GlobalProcedures globalProcedures, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, Pool<KernelTransactionImplementation> pool, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, DatabaseTracers tracers, StorageEngine storageEngine, AccessCapabilityFactory accessCapabilityFactory, CursorContextFactory contextFactory, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState, TokenHolders tokenHolders, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies dependencies, NamedDatabaseId namedDatabaseId, LeaseService leaseService, ScopedMemoryPool dbTransactionsPool, DatabaseReadOnlyChecker readOnlyDatabaseChecker, TransactionExecutionMonitor transactionExecutionMonitor, AbstractSecurityLog securityLog, Locks locks, KernelTransactions kernelTransactions, LogProvider logProvider) {
        this.config = new LocalConfig(externalConfig);
        this.accessCapabilityFactory = accessCapabilityFactory;
        this.contextFactory = contextFactory;
        this.readOnlyDatabaseChecker = readOnlyDatabaseChecker;
        this.transactionMemoryPool = new TransactionMemoryPool(dbTransactionsPool, (Config)this.config, () -> !this.closed, logProvider);
        this.memoryTracker = this.transactionMemoryPool.getTransactionTracker();
        this.eventListeners = eventListeners;
        this.constraintIndexCreator = constraintIndexCreator;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.transactionExecutionMonitor = transactionExecutionMonitor;
        this.storageReader = storageEngine.newReader();
        this.commandCreationContext = storageEngine.newCommandCreationContext();
        this.namedDatabaseId = namedDatabaseId;
        this.storageEngine = storageEngine;
        this.pool = pool;
        this.clocks = new TransactionClockContext(clock);
        this.transactionTracer = tracers.getDatabaseTracer();
        this.leaseService = leaseService;
        this.currentStatement = new KernelStatement(this, tracers.getLockTracer(), this.clocks, cpuClockRef, namedDatabaseId, (Config)this.config);
        this.statistics = new Statistics(this, cpuClockRef, (Boolean)this.config.get(GraphDatabaseInternalSettings.enable_transaction_heap_allocation_tracking));
        this.userMetaData = Collections.emptyMap();
        this.statusDetails = "";
        this.constraintSemantics = constraintSemantics;
        this.transactionalCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);
        this.lockClient = locks.newClient();
        StorageLocks storageLocks = storageEngine.createStorageLocks((ResourceLocker)this.lockClient);
        DefaultPooledCursors cursors = new DefaultPooledCursors(this.storageReader, this.transactionalCursors, (Config)this.config, storageEngine.indexingBehaviour());
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        KernelToken kernelToken = new KernelToken(this.storageReader, this.commandCreationContext, this, tokenHolders);
        this.allStoreHolder = new AllStoreHolder.ForTransactionScope(this.storageReader, (TokenRead)kernelToken, this, storageLocks, cursors, globalProcedures, schemaState, indexingService, indexStatisticsStore, dependencies, this.memoryTracker);
        this.executionContextFactory = KernelTransactionImplementation.createExecutionContextFactory(contextFactory, storageEngine, this.transactionMemoryPool, (Config)this.config, locks, tokenHolders, schemaState, indexingService, indexStatisticsStore, tracers, leaseService, globalProcedures, dependencies, this.securityAuthorizationHandler);
        this.operations = new Operations(this.allStoreHolder, this.storageReader, new IndexTxStateUpdater(this.storageReader, this.allStoreHolder, indexingService), this.commandCreationContext, storageLocks, this, kernelToken, cursors, constraintIndexCreator, constraintSemantics, indexingService, (Config)this.config, this.memoryTracker);
        this.traceProvider = TraceProviderFactory.getTraceProvider((Config)this.config);
        this.transactionHeapBytesLimit = (Long)this.config.get(GraphDatabaseSettings.memory_transaction_max_size);
        this.registerConfigChangeListeners(this.config);
        this.collectionsFactory = collectionsFactorySupplier.create();
        this.kernelTransactions = kernelTransactions;
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, KernelTransaction.Type type, SecurityContext frozenSecurityContext, long transactionTimeout, long transactionSequenceNumber, ClientConnectionInfo clientInfo) {
        assert (this.transactionMemoryPool.usedHeap() == 0L);
        assert (this.transactionMemoryPool.usedNative() == 0L);
        this.cursorContext = this.contextFactory.create(TRANSACTION_TAG);
        this.transactionalCursors.reset(this.cursorContext);
        this.accessCapability = this.accessCapabilityFactory.newAccessCapability(this.readOnlyDatabaseChecker);
        this.kernelTransactionMonitor = KernelTransaction.NO_MONITOR;
        this.type = type;
        this.transactionSequenceNumber = transactionSequenceNumber;
        this.leaseClient = this.leaseService.newClient();
        this.lockClient.initialize(this.leaseClient, transactionSequenceNumber, this.memoryTracker, (Config)this.config);
        this.terminationReason = null;
        this.closing = false;
        this.closed = false;
        this.failure = false;
        this.success = false;
        this.writeState = TransactionWriteState.NONE;
        this.startTimeMillis = this.clocks.systemClock().millis();
        this.startTimeNanos = this.clocks.systemClock().nanos();
        this.timeoutMillis = transactionTimeout;
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.transactionEvent = this.transactionTracer.beginTransaction(this.cursorContext);
        this.overridableSecurityContext = new OverridableSecurityContext(frozenSecurityContext);
        this.transactionId = -1L;
        this.commitTime = -1L;
        this.clientInfo = clientInfo;
        this.statistics.init(Thread.currentThread().getId(), this.cursorContext);
        this.commandCreationContext.initialize(this.cursorContext, this.transactionalCursors, this.kernelTransactions::oldestActiveTransactionSequenceNumber, transactionSequenceNumber, (ResourceLocker)this.lockClient, this.currentStatement::lockTracer);
        this.currentStatement.initialize(this.lockClient, this.cursorContext, this.startTimeMillis);
        this.operations.initialize(this.cursorContext);
        this.initializationTrace = this.traceProvider.getTraceInfo();
        this.transactionMemoryPool.setLimit(this.transactionHeapBytesLimit);
        this.innerTransactionHandler = new InnerTransactionHandlerImpl(this.kernelTransactions);
        return this;
    }

    private static ExecutionContextFactory createExecutionContextFactory(CursorContextFactory contextFactory, StorageEngine storageEngine, TransactionMemoryPool transactionMemoryPool, Config config, Locks locks, TokenHolders tokenHolders, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, DatabaseTracers tracers, LeaseService leaseService, GlobalProcedures globalProcedures, Dependencies dependencies, SecurityAuthorizationHandler securityAuthorizationHandler) {
        return (securityContext, transactionId, transactionCursorContext, clockContextSupplier, assertOpen) -> {
            ExecutionContextCursorTracer executionContextCursorTracer = new ExecutionContextCursorTracer(PageCacheTracer.NULL, "transactionExecution");
            CursorContext executionContextCursorContext = contextFactory.create((PageCursorTracer)executionContextCursorTracer);
            StorageReader executionContextStorageReader = storageEngine.newReader();
            MemoryTracker executionContextMemoryTracker = transactionMemoryPool.getPoolMemoryTracker();
            StoreCursors executionContextStoreCursors = storageEngine.createStorageCursors(executionContextCursorContext);
            DefaultPooledCursors executionContextPooledCursors = new DefaultPooledCursors(executionContextStorageReader, executionContextStoreCursors, config, storageEngine.indexingBehaviour());
            Locks.Client executionContextLockClient = locks.newClient();
            executionContextLockClient.initialize(leaseService.newClient(), transactionId, executionContextMemoryTracker, config);
            OverridableSecurityContext overridableSecurityContext = new OverridableSecurityContext(securityContext);
            KernelTokenRead.ForThreadExecutionContextScope executionContextTokenRead = new KernelTokenRead.ForThreadExecutionContextScope(executionContextStorageReader, tokenHolders, overridableSecurityContext, assertOpen);
            AllStoreHolder.ForThreadExecutionContextScope executionContextRead = new AllStoreHolder.ForThreadExecutionContextScope(executionContextStorageReader, executionContextTokenRead, schemaState, indexingService, indexStatisticsStore, globalProcedures, executionContextMemoryTracker, dependencies, executionContextPooledCursors, executionContextStoreCursors, executionContextCursorContext, storageEngine.createStorageLocks((ResourceLocker)executionContextLockClient), executionContextLockClient, tracers.getLockTracer(), overridableSecurityContext, assertOpen, securityAuthorizationHandler, clockContextSupplier);
            return new ThreadExecutionContext(executionContextCursorContext, overridableSecurityContext, executionContextCursorTracer, transactionCursorContext, executionContextRead, executionContextTokenRead, executionContextStoreCursors, indexingService.getMonitor(), executionContextMemoryTracker, securityAuthorizationHandler, List.of(executionContextStorageReader, executionContextLockClient));
        };
    }

    public void bindToUserTransaction(InternalTransaction internalTransaction) {
        this.internalTransaction = internalTransaction;
    }

    public InternalTransaction internalTransaction() {
        return this.internalTransaction;
    }

    public long startTime() {
        return this.startTimeMillis;
    }

    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public long timeout() {
        return this.timeoutMillis;
    }

    public void success() {
        this.success = true;
    }

    boolean isSuccess() {
        return this.success;
    }

    public boolean canCommit() {
        return this.success && !this.failure && this.terminationReason == null;
    }

    public void failure() {
        this.failure = true;
    }

    public Optional<Status> getReasonIfTerminated() {
        return Optional.ofNullable(this.terminationReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markForTermination(long expectedTransactionSequenceNumber, Status reason) {
        this.terminationReleaseLock.lock();
        try {
            boolean bl = expectedTransactionSequenceNumber == this.transactionSequenceNumber && this.markForTerminationIfPossible(reason);
            return bl;
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public void markForTermination(Status reason) {
        this.terminationReleaseLock.lock();
        try {
            this.markForTerminationIfPossible(reason);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public boolean isSchemaTransaction() {
        return this.writeState == TransactionWriteState.SCHEMA;
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public ExecutionContext createExecutionContext() {
        if (this.hasTxStateWithChanges()) {
            throw new IllegalStateException("Execution context cannot be used for transactions with non-empty transaction state");
        }
        long transactionSequenceNumberWhenCreated = this.transactionSequenceNumber;
        if (this.clocks.statementClock() == null) {
            throw new IllegalStateException("Execution context must be created when there is an active statement");
        }
        ExecutionContextClock statementClock = new ExecutionContextClock((Clock)this.clocks.systemClock(), this.clocks.transactionClock(), this.clocks.statementClock());
        return this.executionContextFactory.createNew(this.overridableSecurityContext.originalSecurityContext(), this.transactionSequenceNumber, this.cursorContext, () -> statementClock, () -> {
            this.assertOpen();
            if (transactionSequenceNumberWhenCreated != this.transactionSequenceNumber) {
                throw new IllegalStateException("Execution context used after transaction close");
            }
        });
    }

    public QueryContext queryContext() {
        return this.operations.queryContext();
    }

    public StoreCursors storeCursors() {
        return this.transactionalCursors;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    private boolean markForTerminationIfPossible(Status reason) {
        if (this.canBeTerminated()) {
            InnerTransactionHandlerImpl innerTransactionHandler = this.innerTransactionHandler;
            if (innerTransactionHandler != null) {
                innerTransactionHandler.terminateInnerTransactions(reason);
            }
            this.failure = true;
            this.terminationReason = reason;
            if (this.lockClient != null) {
                this.lockClient.stop();
            }
            this.transactionMonitor.transactionTerminated(this.hasTxState());
            InternalTransaction internalTransaction = this.internalTransaction;
            if (internalTransaction != null) {
                internalTransaction.terminate(reason);
            }
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    public SecurityContext securityContext() {
        if (this.overridableSecurityContext == null) {
            throw new NotInTransactionException();
        }
        return this.overridableSecurityContext.currentSecurityContext();
    }

    public AuthSubject subjectOrAnonymous() {
        if (this.overridableSecurityContext == null) {
            return AuthSubject.ANONYMOUS;
        }
        return this.overridableSecurityContext.currentSecurityContext().subject();
    }

    public void setMetaData(Map<String, Object> data) {
        this.assertOpen();
        this.userMetaData = data;
    }

    public Map<String, Object> getMetaData() {
        return this.userMetaData;
    }

    public void setStatusDetails(String statusDetails) {
        this.assertOpen();
        this.statusDetails = statusDetails;
    }

    public String statusDetails() {
        String details = this.statusDetails;
        return StringUtils.defaultString((String)details, (String)"");
    }

    public KernelStatement acquireStatement() {
        this.assertOpen();
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.operations.indexUniqueCreate(prototype);
    }

    public long pageHits() {
        return this.cursorContext.getCursorTracer().hits();
    }

    public long pageFaults() {
        return this.cursorContext.getCursorTracer().faults();
    }

    Optional<ExecutingQuery> executingQuery() {
        return this.currentStatement.executingQuery();
    }

    private void upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToDataWrites();
    }

    private void upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToSchemaWrites();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            Iterator createdIndexIds = this.txState().constraintIndexesCreatedInTx();
            while (createdIndexIds.hasNext()) {
                IndexDescriptor createdIndex = (IndexDescriptor)createdIndexIds.next();
                this.constraintIndexCreator.dropUniquenessConstraintIndex(createdIndex);
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.leaseClient.ensureValid();
            this.readOnlyDatabaseChecker.check();
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txState = new TxState(this.collectionsFactory, this.memoryTracker, this.storageEngine.transactionStateBehaviour());
        }
        return this.txState;
    }

    private boolean hasTxState() {
        return this.txState != null;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.hasTxState() && this.txState.hasChanges();
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges();
    }

    private void markAsClosed() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
    }

    private void closeCurrentStatementIfAny() {
        this.currentStatement.forceClose();
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new NotInTransactionException("This transaction has already been closed.");
        }
    }

    public void assertOpen() {
        Status reason = this.terminationReason;
        if (reason != null) {
            throw new TransactionTerminatedException(reason);
        }
        this.assertTransactionOpen();
    }

    public long commit(KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor) throws TransactionFailureException {
        this.success();
        this.kernelTransactionMonitor = kernelTransactionMonitor;
        return this.closeTransaction();
    }

    public void rollback() throws TransactionFailureException {
        if (!this.isOpen() && this.failure) {
            return;
        }
        this.failure();
        this.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long closeTransaction() throws TransactionFailureException {
        this.assertTransactionOpen();
        this.assertTransactionNotClosing();
        this.assertNoInnerTransactions();
        this.closing = true;
        Throwable exception = null;
        long txId = -1L;
        try {
            if (this.canCommit()) {
                txId = this.commitTransaction();
            } else {
                this.rollback(null);
                this.failOnNonExplicitRollbackIfNeeded();
                txId = -1L;
            }
        }
        catch (RuntimeException | TransactionFailureException e) {
            exception = e;
        }
        catch (KernelException e) {
            exception = new TransactionFailureException(e.status(), (Throwable)e, "Unexpected kernel exception", new Object[0]);
        }
        finally {
            try {
                this.closed();
            }
            catch (RuntimeException e) {
                exception = (Exception)Exceptions.chain((Throwable)exception, (Throwable)e);
            }
            finally {
                try {
                    this.reset();
                }
                catch (RuntimeException e) {
                    exception = (Exception)Exceptions.chain((Throwable)exception, (Throwable)e);
                }
            }
        }
        if (exception == null) {
            return txId;
        }
        if (this.leaseClient.leaseId() != -1) {
            try {
                this.leaseClient.ensureValid();
            }
            catch (RuntimeException e) {
                exception = (Exception)Exceptions.chain((Throwable)exception, (Throwable)e);
            }
        }
        if (exception instanceof TransactionFailureException) {
            TransactionFailureException e = (TransactionFailureException)exception;
            throw e;
        }
        throw (RuntimeException)exception;
    }

    private void closed() {
        this.closed = true;
        this.closing = false;
        this.transactionEvent.setSuccess(this.success);
        this.transactionEvent.setFailure(this.failure);
        this.transactionEvent.setTransactionWriteState(this.writeState.name());
        this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
        this.transactionEvent.close();
    }

    public void close() throws TransactionFailureException {
        if (this.isOpen()) {
            this.closeTransaction();
        }
        this.pool.release((Object)this);
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void failOnNonExplicitRollbackIfNeeded() throws TransactionFailureException {
        if (this.success && this.isTerminated()) {
            throw new TransactionTerminatedException(this.terminationReason);
        }
        if (this.success) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionMarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
        }
    }

    /*
     * Loose catch block
     */
    private long commitTransaction() throws KernelException {
        long l;
        CommitEvent commitEvent;
        TransactionListenersState listenersState;
        long txId;
        boolean success;
        block19: {
            block18: {
                success = false;
                txId = 0L;
                listenersState = null;
                commitEvent = this.transactionEvent.beginCommitEvent();
                listenersState = this.eventListeners.beforeCommit(this.txState, this, this.storageReader);
                if (listenersState != null && listenersState.isFailed()) {
                    Throwable cause = listenersState.failure();
                    if (cause instanceof TransientFailureException) {
                        throw (TransientFailureException)cause;
                    }
                    if (cause instanceof Status.HasStatus) {
                        throw new TransactionFailureException(((Status.HasStatus)cause).status(), cause, cause.getMessage(), new Object[0]);
                    }
                    throw new TransactionFailureException((Status)Status.Transaction.TransactionHookFailed, cause, cause.getMessage(), new Object[0]);
                }
                if (this.hasChanges()) {
                    this.schemaTransactionVersionReset();
                    this.lockClient.prepareForCommit();
                    List extractedCommands = this.storageEngine.createCommands((ReadableTransactionState)this.txState, this.storageReader, this.commandCreationContext, this.lockTracer(), tx -> this.enforceConstraints((TxStateVisitor)tx, this.memoryTracker), this.cursorContext, this.transactionalCursors, this.memoryTracker);
                    if (!extractedCommands.isEmpty()) {
                        long timeCommitted = this.clocks.systemClock().millis();
                        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(extractedCommands, ArrayUtils.EMPTY_BYTE_ARRAY, this.startTimeMillis, this.lastTransactionIdWhenStarted, timeCommitted, this.leaseClient.leaseId(), this.overridableSecurityContext.currentSecurityContext().subject().userSubject());
                        success = true;
                        TransactionToApply batch = new TransactionToApply(transactionRepresentation, this.cursorContext, this.transactionalCursors);
                        this.kernelTransactionMonitor.beforeApply();
                        txId = this.commitProcess.commit(batch, commitEvent, TransactionApplicationMode.INTERNAL);
                        this.commitTime = timeCommitted;
                    }
                }
                success = true;
                l = txId;
                if (commitEvent != null) {
                    commitEvent.close();
                }
                if (success) break block18;
                this.rollback(listenersState);
                break block19;
            }
            this.transactionId = txId;
            this.afterCommit(listenersState);
        }
        this.transactionMonitor.addHeapTransactionSize(this.transactionMemoryPool.usedHeap());
        this.transactionMonitor.addNativeTransactionSize(this.transactionMemoryPool.usedNative());
        return l;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (commitEvent != null) {
                            try {
                                commitEvent.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConstraintValidationException | CreateConstraintFailureException e) {
                        throw new ConstraintViolationTransactionFailureException(e.getUserMessage((TokenNameLookup)this.tokenRead()), (KernelException)e);
                    }
                }
                catch (Throwable throwable3) {
                    if (!success) {
                        this.rollback(listenersState);
                    } else {
                        this.transactionId = txId;
                        this.afterCommit(listenersState);
                    }
                    this.transactionMonitor.addHeapTransactionSize(this.transactionMemoryPool.usedHeap());
                    this.transactionMonitor.addNativeTransactionSize(this.transactionMemoryPool.usedNative());
                    throw throwable3;
                }
            }
        }
    }

    private void schemaTransactionVersionReset() {
        if (this.isSchemaTransaction()) {
            this.cursorContext.getVersionContext().initRead();
        }
    }

    private void rollback(TransactionListenersState listenersState) throws KernelException {
        try {
            AutoCloseable constraintDropper = () -> {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                catch (IllegalStateException | SecurityException e) {
                    throw new TransactionFailureException((Status)Status.Transaction.TransactionRollbackFailed, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
                }
            };
            AutoCloseable storageRollback = () -> {
                if (this.txState != null) {
                    try (CursorContext rollbackContext = this.contextFactory.create("transaction rollback");){
                        this.storageEngine.rollback((ReadableTransactionState)this.txState, rollbackContext);
                    }
                }
            };
            IOUtils.close((s, throwable) -> throwable, (AutoCloseable[])new AutoCloseable[]{constraintDropper, storageRollback});
        }
        catch (Error | RuntimeException | KernelException e) {
            throw e;
        }
        catch (Throwable throwable2) {
            throw new UnspecifiedKernelException((Status)Status.Transaction.TransactionRollbackFailed, throwable2);
        }
        finally {
            this.afterRollback(listenersState);
        }
    }

    public Read dataRead() {
        return this.operations.dataRead();
    }

    public Write dataWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.upgradeToDataWrites();
        return this.operations;
    }

    public TokenWrite tokenWrite() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public Token token() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public TokenRead tokenRead() {
        return this.operations.token();
    }

    public SchemaRead schemaRead() {
        return this.operations.schemaRead();
    }

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.upgradeToSchemaWrites();
        return new RestrictedSchemaWrite(this.operations, this.securityContext(), this.securityAuthorizationHandler);
    }

    public org.neo4j.internal.kernel.api.Locks locks() {
        return this.operations.locks();
    }

    public Locks.Client lockClient() {
        this.assertOpen();
        return this.lockClient;
    }

    public CursorFactory cursors() {
        return this.operations.cursors();
    }

    public Procedures procedures() {
        return this.operations.procedures();
    }

    public ExecutionStatistics executionStatistics() {
        return this;
    }

    public LockTracer lockTracer() {
        return this.currentStatement.lockTracer();
    }

    private void afterCommit(TransactionListenersState listenersState) {
        try {
            this.markAsClosed();
            this.eventListeners.afterCommit(listenersState);
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxState());
            this.transactionExecutionMonitor.commit(this);
        }
    }

    private void afterRollback(TransactionListenersState listenersState) {
        try {
            this.markAsClosed();
            this.eventListeners.afterRollback(listenersState);
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxState());
            if (listenersState == null || listenersState.failure() == null) {
                this.transactionExecutionMonitor.rollback(this);
            } else {
                this.transactionExecutionMonitor.rollback(this, listenersState.failure());
            }
        }
    }

    void releaseStatementResources() {
        this.allStoreHolder.release();
    }

    private void reset() {
        this.terminationReleaseLock.lock();
        try {
            this.lockClient.close();
            this.terminationReason = null;
            this.type = null;
            this.overridableSecurityContext = null;
            this.transactionEvent = null;
            this.txState = null;
            this.collectionsFactory.release();
            this.userMetaData = Collections.emptyMap();
            this.statusDetails = "";
            this.clientInfo = null;
            this.internalTransaction = null;
            this.transactionSequenceNumber = 0L;
            this.statistics.reset();
            this.releaseStatementResources();
            this.operations.release();
            this.commandCreationContext.close();
            this.transactionalCursors.close();
            this.cursorContext.close();
            this.initializationTrace = TransactionInitializationTrace.NONE;
            this.transactionMemoryPool.reset();
            this.innerTransactionHandler.close();
            this.innerTransactionHandler = null;
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    private boolean canBeTerminated() {
        return !this.closed && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminationReason != null;
    }

    public KernelTransaction.Type transactionType() {
        return this.type;
    }

    public long getTransactionId() {
        if (this.transactionId == -1L) {
            throw new IllegalStateException("Transaction id is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.transactionId;
    }

    public long getCommitTime() {
        if (this.commitTime == -1L) {
            throw new IllegalStateException("Transaction commit time is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.commitTime;
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        OverridableSecurityContext.Revertable revertable = this.overridableSecurityContext.overrideWith(context);
        return () -> revertable.close();
    }

    public String toString() {
        return String.format("KernelTransaction[lease:%d]", this.leaseClient.leaseId());
    }

    public void dispose() {
        this.storageReader.close();
        this.transactionMemoryPool.close();
        this.removeConfigChangeListeners(this.config);
    }

    public Stream<ActiveLock> activeLocks() {
        Locks.Client locks = this.lockClient;
        return locks == null ? Stream.empty() : locks.activeLocks();
    }

    public long getTransactionSequenceNumber() {
        return this.transactionSequenceNumber;
    }

    TransactionInitializationTrace getInitializationTrace() {
        return this.initializationTrace;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private TxStateVisitor enforceConstraints(TxStateVisitor txStateVisitor, MemoryTracker memoryTracker) {
        return this.constraintSemantics.decorateTxStateVisitor(this.storageReader, this.operations.dataRead(), this.operations.cursors(), this.txState, txStateVisitor, this.cursorContext, memoryTracker);
    }

    public ClientConnectionInfo clientInfo() {
        return this.clientInfo;
    }

    public StorageReader newStorageReader() {
        return this.storageEngine.newReader();
    }

    public void addIndexDoDropToTxState(IndexDescriptor index) {
        this.txState().indexDoDrop(index);
    }

    public String getDatabaseName() {
        return this.namedDatabaseId.name();
    }

    public UUID getDatabaseId() {
        return this.namedDatabaseId.databaseId().uuid();
    }

    public InnerTransactionHandlerImpl getInnerTransactionHandler() {
        if (this.innerTransactionHandler != null) {
            return this.innerTransactionHandler;
        }
        throw new IllegalStateException("Called getInnerTransactionHandler on inactive transaction");
    }

    private void assertNoInnerTransactions() throws TransactionFailureException {
        if (this.getInnerTransactionHandler().hasInnerTransaction()) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, "The transaction cannot be committed when it has open inner transactions.", new Object[0]);
        }
    }

    public TransactionClockContext clocks() {
        return this.clocks;
    }

    public NodeCursor ambientNodeCursor() {
        return this.operations.nodeCursor();
    }

    public RelationshipScanCursor ambientRelationshipCursor() {
        return this.operations.relationshipCursor();
    }

    public PropertyCursor ambientPropertyCursor() {
        return this.operations.propertyCursor();
    }

    private void registerConfigChangeListeners(LocalConfig config) {
        config.addListener(GraphDatabaseSettings.transaction_tracing_level, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        });
        config.addListener(GraphDatabaseSettings.transaction_sampling_percentage, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        });
        config.addListener(GraphDatabaseSettings.memory_transaction_max_size, (before, after) -> {
            this.transactionHeapBytesLimit = after;
        });
    }

    private void removeConfigChangeListeners(LocalConfig config) {
        config.removeAllLocalListeners();
    }

    public static class Statistics {
        private volatile long cpuTimeNanosWhenQueryStarted;
        private volatile long heapAllocatedBytesWhenQueryStarted;
        private volatile long waitingTimeNanos;
        private volatile long transactionThreadId;
        private volatile CursorContext cursorContext = CursorContext.NULL_CONTEXT;
        private final KernelTransactionImplementation transaction;
        private final AtomicReference<CpuClock> cpuClockRef;
        private CpuClock cpuClock;
        private final HeapAllocation heapAllocation;

        public Statistics(KernelTransactionImplementation transaction, AtomicReference<CpuClock> cpuClockRef, boolean heapAllocationTracking) {
            this.transaction = transaction;
            this.cpuClockRef = cpuClockRef;
            this.heapAllocation = heapAllocationTracking ? HeapAllocation.HEAP_ALLOCATION : HeapAllocation.NOT_AVAILABLE;
        }

        protected void init(long threadId, CursorContext cursorContext) {
            this.cpuClock = this.cpuClockRef.get();
            this.transactionThreadId = threadId;
            this.cursorContext = cursorContext;
            this.cpuTimeNanosWhenQueryStarted = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            this.heapAllocatedBytesWhenQueryStarted = this.heapAllocation.allocatedBytes(this.transactionThreadId);
        }

        long heapAllocatedBytes() {
            long allocatedBytes = this.heapAllocation.allocatedBytes(this.transactionThreadId);
            return allocatedBytes < 0L ? -1L : allocatedBytes - this.heapAllocatedBytesWhenQueryStarted;
        }

        long estimatedHeapMemory() {
            return this.transaction.transactionMemoryPool.usedHeap();
        }

        long usedNativeMemory() {
            return this.transaction.transactionMemoryPool.usedNative();
        }

        public long cpuTimeMillis() {
            long cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            return cpuTimeNanos < 0L ? -1L : TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos - this.cpuTimeNanosWhenQueryStarted);
        }

        long totalTransactionPageCacheHits() {
            return this.cursorContext.getCursorTracer().hits();
        }

        long totalTransactionPageCacheFaults() {
            return this.cursorContext.getCursorTracer().faults();
        }

        void addWaitingTime(long waitTimeNanos) {
            this.waitingTimeNanos += waitTimeNanos;
        }

        long getWaitingTimeNanos(long nowNanos) {
            Optional<ExecutingQuery> query = this.transaction.executingQuery();
            long waitingTime = this.waitingTimeNanos;
            if (query.isPresent()) {
                long latestQueryWaitingNanos = query.get().totalWaitingTimeNanos(nowNanos);
                waitingTime += latestQueryWaitingNanos;
            }
            return waitingTime;
        }

        void reset() {
            this.cursorContext = CursorContext.NULL_CONTEXT;
            this.cpuTimeNanosWhenQueryStarted = 0L;
            this.heapAllocatedBytesWhenQueryStarted = 0L;
            this.waitingTimeNanos = 0L;
            this.transactionThreadId = -1L;
        }
    }

    private static interface ExecutionContextFactory {
        public ExecutionContext createNew(SecurityContext var1, long var2, CursorContext var4, Supplier<ClockContext> var5, AssertOpen var6);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TransactionWriteState {
        NONE,
        DATA{

            @Override
            TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }

    private record ExecutionContextClock(Clock systemClock, Clock transactionClock, Clock statementClock) implements ClockContext
    {
    }
}

