/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.logging.Level;
import org.neo4j.values.storable.DurationValue;

public class CommunityTopologyGraphDbmsModel
implements TopologyGraphDbmsModel {
    protected final Transaction tx;

    public CommunityTopologyGraphDbmsModel(Transaction tx) {
        this.tx = tx;
    }

    public Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> getAllDatabaseAccess() {
        try (ResourceIterator nodes = this.tx.findNodes(DATABASE_LABEL);){
            Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> map = nodes.stream().collect(Collectors.toMap(CommunityTopologyGraphDbmsModel::getDatabaseId, CommunityTopologyGraphDbmsModel::getDatabaseAccess));
            return map;
        }
    }

    private static TopologyGraphDbmsModel.DatabaseAccess getDatabaseAccess(Node databaseNode) {
        String accessString = (String)databaseNode.getProperty("access", (Object)TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        return Enum.valueOf(TopologyGraphDbmsModel.DatabaseAccess.class, accessString);
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String databaseName) {
        return this.getDatabaseIdByAlias0(databaseName).or(() -> this.getDatabaseIdBy("name", databaseName));
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid) {
        return this.getDatabaseIdBy("uuid", uuid.toString());
    }

    @Override
    public Set<NamedDatabaseId> getAllDatabaseIds() {
        try (ResourceIterator nodes = this.tx.findNodes(DATABASE_LABEL);){
            Set<NamedDatabaseId> set = nodes.stream().map(CommunityTopologyGraphDbmsModel::getDatabaseId).collect(Collectors.toUnmodifiableSet());
            return set;
        }
    }

    private Stream<DatabaseReference.Internal> getAllPrimaryStandardDatabaseReferencesInRoot() {
        return this.tx.findNodes(DATABASE_LABEL).stream().filter(node -> !node.hasProperty("virtual")).map(CommunityTopologyGraphDbmsModel::getDatabaseId).map(this::primaryRefFromDatabaseId);
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        Stream<DatabaseReference.Internal> primaryRefs = this.getAllPrimaryStandardDatabaseReferencesInRoot();
        Stream<DatabaseReference.Internal> internalAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        Stream<DatabaseReference.Internal> internalRefs = Stream.concat(primaryRefs, internalAliasRefs);
        Stream<DatabaseReference.External> externalRefs = this.getAllExternalDatabaseReferencesInRoot();
        Stream<DatabaseReference.Composite> compositeRefs = this.getAllCompositeDatabaseReferencesInRoot();
        return Stream.of(internalRefs, externalRefs, compositeRefs).flatMap(s -> s).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReference.Internal> getAllInternalDatabaseReferences() {
        Stream<DatabaseReference.Internal> primaryRefs = this.getAllPrimaryStandardDatabaseReferencesInRoot();
        Stream<DatabaseReference.Internal> localAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        return Stream.concat(primaryRefs, localAliasRefs).collect(Collectors.toUnmodifiableSet());
    }

    private DatabaseReference.Internal primaryRefFromDatabaseId(NamedDatabaseId databaseId) {
        NormalizedDatabaseName alias = new NormalizedDatabaseName(databaseId.name());
        return new DatabaseReference.Internal(alias, databaseId, true);
    }

    private Stream<DatabaseReference.Internal> getAllInternalDatabaseReferencesInRoot() {
        return this.getAllInternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReference.Internal> getAllInternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, namespace).flatMap(alias -> CommunityTopologyGraphDbmsModel.getTargetedDatabaseNode(alias).filter(node -> !node.hasProperty("virtual")).map(CommunityTopologyGraphDbmsModel::getDatabaseId).flatMap(db -> this.createInternalReference((Node)alias, (NamedDatabaseId)db)).stream());
    }

    private Optional<DatabaseReference.Internal> createInternalReference(Node alias, NamedDatabaseId targetedDatabase) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_NAME, alias, "name", String.class));
            Boolean primary = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_NAME, alias, "primary", Boolean.class);
            return Optional.of(new DatabaseReference.Internal(aliasName, targetedDatabase, primary));
        });
    }

    @Override
    public Set<DatabaseReference.External> getAllExternalDatabaseReferences() {
        return this.getAllExternalDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    private Stream<DatabaseReference.External> getAllExternalDatabaseReferencesInRoot() {
        return this.getAllExternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReference.External> getAllExternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAliasNodesInNamespace(REMOTE_DATABASE_LABEL, namespace).flatMap(alias -> this.createExternalReference((Node)alias).stream());
    }

    private Optional<DatabaseReference.External> createExternalReference(Node ref) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            String uriString = CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "url", String.class);
            NormalizedDatabaseName targetName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "target_name", String.class));
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "name", String.class));
            URI uri = URI.create(uriString);
            SocketAddress host = SocketAddressParser.socketAddress((URI)uri, (int)7687, SocketAddress::new);
            RemoteUri remoteUri = new RemoteUri(uri.getScheme(), List.of(host), uri.getQuery());
            String uuid = CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "version", String.class);
            return Optional.of(new DatabaseReference.External(targetName, aliasName, remoteUri, UUID.fromString(uuid)));
        });
    }

    @Override
    public Set<DatabaseReference.Composite> getAllCompositeDatabaseReferences() {
        return this.getAllCompositeDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    private Stream<DatabaseReference.Composite> getAllCompositeDatabaseReferencesInRoot() {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root").flatMap(alias -> CommunityTopologyGraphDbmsModel.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReference.Composite> createCompositeReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = this.getName(DATABASE_NAME, alias);
            NormalizedDatabaseName compositeName = this.getName(DATABASE, db);
            Set<DatabaseReference> components = this.getAllDatabaseReferencesInComposite(compositeName);
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModel.getDatabaseId(db);
            return Optional.of(new DatabaseReference.Composite(aliasName, databaseId, components));
        });
    }

    private NormalizedDatabaseName getName(String labelName, Node node) {
        return new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode(labelName, node, "name", String.class));
    }

    private Stream<Node> getAliasNodesInNamespace(Label label, String namespace) {
        return this.tx.findNodes(label, "namespace", (Object)namespace).stream();
    }

    private Set<DatabaseReference> getAllDatabaseReferencesInComposite(NormalizedDatabaseName compositeName) {
        Stream<DatabaseReference.Internal> internalRefs = this.getAllInternalDatabaseReferencesInNamespace(compositeName.name());
        Stream<DatabaseReference.External> externalRefs = this.getAllExternalDatabaseReferencesInNamespace(compositeName.name());
        return Stream.concat(internalRefs, externalRefs).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByAlias(String databaseName) {
        return this.getInternalDatabaseReference(databaseName).or(() -> this.getExternalDatabaseReference(databaseName));
    }

    @Override
    public Optional<DriverSettings> getDriverSettings(String databaseName, String namespace) {
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModel::getDriverSettings);
    }

    @Override
    public Optional<Map<String, Object>> getAliasProperties(String databaseName, String namespace) {
        return this.tx.findNodes(DATABASE_NAME_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModel::getAliasProperties);
    }

    @Override
    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(String databaseName, String namespace) {
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModel::getDatabaseCredentials);
    }

    private static Optional<DriverSettings> getDriverSettings(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            List connectsWith = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{CONNECTS_WITH_RELATIONSHIP}).spliterator(), false).toList();
            return connectsWith.stream().findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModel::createDriverSettings);
        });
    }

    private static Optional<Map<String, Object>> getAliasProperties(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            List propertiesRels = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{PROPERTIES_RELATIONSHIP}).spliterator(), false).toList();
            return propertiesRels.stream().findFirst().map(Relationship::getEndNode).map(Entity::getAllProperties);
        });
    }

    private static Optional<ExternalDatabaseCredentials> getDatabaseCredentials(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            String username = CommunityTopologyGraphDbmsModel.getPropertyOnNode(REMOTE_DATABASE, aliasNode, "username", String.class);
            byte[] password = CommunityTopologyGraphDbmsModel.getPropertyOnNode(REMOTE_DATABASE, aliasNode, "password", byte[].class);
            byte[] iv = CommunityTopologyGraphDbmsModel.getPropertyOnNode(REMOTE_DATABASE, aliasNode, "iv", byte[].class);
            return Optional.of(new ExternalDatabaseCredentials(username, password, iv));
        });
    }

    private static DriverSettings createDriverSettings(Node driverSettingsNode) {
        DriverSettings.Builder builder = DriverSettings.builder();
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "ssl_enforced", Boolean.class).map(builder::withSslEnforced);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_timeout", DurationValue.class).map(builder::withConnectionTimeout);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_max_lifetime", DurationValue.class).map(builder::withConnectionMaxLifeTime);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, DriverSettings.Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString(), DurationValue.class).map(builder::withConnectionPoolAcquisitionTimeout);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_pool_idle_test", DurationValue.class).map(builder::withConnectionPoolIdleTest);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_pool_max_size", Integer.class).map(builder::withConnectionPoolMaxSize);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "logging_level", String.class).map(Level::valueOf).map(builder::withLoggingLevel);
        return builder.build();
    }

    private Optional<DatabaseReference> getInternalDatabaseReference(String databaseName) {
        Optional<Node> aliasNode = this.findAliasNodeInDefaultNamespace(databaseName);
        return aliasNode.flatMap(alias -> CommunityTopologyGraphDbmsModel.getTargetedDatabase(alias).flatMap(db -> this.createInternalReference((Node)alias, (NamedDatabaseId)db)));
    }

    private Optional<DatabaseReference> getExternalDatabaseReference(String databaseName) {
        return Optional.ofNullable(this.tx.findNode(REMOTE_DATABASE_LABEL, "name", (Object)databaseName)).flatMap(this::createExternalReference);
    }

    private Optional<NamedDatabaseId> getDatabaseIdByAlias0(String databaseName) {
        return this.findAliasNodeInDefaultNamespace(databaseName).flatMap(CommunityTopologyGraphDbmsModel::getTargetedDatabase);
    }

    private Optional<NamedDatabaseId> getDatabaseIdBy(String propertyKey, String propertyValue) {
        try {
            Node node = this.tx.findNode(DATABASE_LABEL, propertyKey, (Object)propertyValue);
            if (node == null) {
                return Optional.empty();
            }
            String databaseName = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_LABEL.name(), node, "name", String.class);
            String databaseUuid = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_LABEL.name(), node, "uuid", String.class);
            return Optional.of(DatabaseIdFactory.from((String)databaseName, (UUID)UUID.fromString(databaseUuid)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<NamedDatabaseId> getTargetedDatabase(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            try (Stream stream = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TARGETS_RELATIONSHIP}).stream();){
                Optional<NamedDatabaseId> optional = stream.findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModel::getDatabaseId);
                return optional;
            }
        });
    }

    private static Optional<Node> getTargetedDatabaseNode(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            try (Stream stream = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TARGETS_RELATIONSHIP}).stream();){
                Optional<Node> optional = stream.findFirst().map(Relationship::getEndNode);
                return optional;
            }
        });
    }

    private static NamedDatabaseId getDatabaseId(Node databaseNode) {
        String name = (String)databaseNode.getProperty("name");
        UUID uuid = UUID.fromString((String)databaseNode.getProperty("uuid"));
        return DatabaseIdFactory.from((String)name, (UUID)uuid);
    }

    private static <T> Optional<T> getOptionalPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value;
        try {
            value = node.getProperty(key);
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        if (value == null) {
            return Optional.empty();
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return Optional.of(type.cast(value));
    }

    private static <T> T getPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value = node.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("%s has no property %s.", labelName, key));
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return type.cast(value);
    }

    private Optional<Node> findAliasNodeInDefaultNamespace(String databaseName) {
        return this.tx.findNodes(DATABASE_NAME_LABEL, "name", (Object)databaseName).stream().filter(n -> CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DATABASE_NAME, n, "namespace", String.class).orElse("system-root").equals("system-root")).findFirst();
    }

    private static <T> Optional<T> ignoreConcurrentDeletes(Supplier<Optional<T>> operation) {
        try {
            return operation.get();
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }
}

