/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import org.neo4j.common.Subject;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.transaction.log.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesSpan;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionLogInitializer {
    private final FileSystemAbstraction fs;
    private final MetadataProvider store;
    private final StorageEngineFactory storageEngineFactory;
    private final MetadataCache metadataCache;

    public static LogFilesInitializer getLogFilesInitializer() {
        return new LogFilesInitializer(){

            public void initializeLogFiles(DatabaseLayout databaseLayout, MetadataProvider store, MetadataCache metadataCache, FileSystemAbstraction fileSystem, String checkpointReason) {
                try {
                    TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, store, (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow(), metadataCache);
                    initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason);
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Failed to initialize transaction log files.", (Throwable)e);
                }
            }

            public void clearHistoryAndInitializeLogFiles(DatabaseLayout databaseLayout, MetadataProvider store, MetadataCache metadataCache, FileSystemAbstraction fileSystem, String checkpointReason) {
                try {
                    TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, store, (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow(), metadataCache);
                    initializer.migrateExistingLogFiles(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason);
                }
                catch (Exception e) {
                    throw new UnderlyingStorageException("Failed to clear history and initialize transaction log files.", (Throwable)e);
                }
            }
        };
    }

    public TransactionLogInitializer(FileSystemAbstraction fs, MetadataProvider store, StorageEngineFactory storageEngineFactory, MetadataCache metadataCache) {
        this.fs = fs;
        this.store = store;
        this.storageEngineFactory = storageEngineFactory;
        this.metadataCache = metadataCache;
    }

    public long initializeEmptyLogFile(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason) throws IOException {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    public long migrateExistingLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason) throws Exception {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            LogFile logFile = logFiles.getLogFile();
            for (long version = logFile.getLowestLogVersion(); version <= logFile.getHighestLogVersion(); ++version) {
                this.fs.deleteFile(logFile.getLogFileForVersion(version));
            }
            CheckpointFile checkpointFile = logFiles.getCheckpointFile();
            for (long version = checkpointFile.getLowestLogVersion(); version <= checkpointFile.getHighestLogVersion(); ++version) {
                this.fs.deleteFile(checkpointFile.getDetachedCheckpointFileForVersion(version));
            }
            logFile.rotate();
            checkpointFile.rotate();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    private LogFilesSpan buildLogFiles(DatabaseLayout layout, Path transactionLogsDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder(layout, this.fs, (KernelVersionProvider)this.metadataCache).withLogVersionRepository((LogVersionRepository)this.store).withTransactionIdStore((TransactionIdStore)this.store).withStoreId(this.store.getStoreId()).withLogsDirectory(transactionLogsDirectory).withStorageEngineFactory(this.storageEngineFactory).withDatabaseHealth(new DatabaseHealth(HealthEventGenerator.NO_OP, (InternalLog)NullLog.getInstance())).build();
        return new LogFilesSpan(new Lifespan(new Lifecycle[]{logFiles}), logFiles);
    }

    private long appendEmptyTransactionAndCheckPoint(LogFiles logFiles, String reason) throws IOException {
        TransactionId committedTx = this.store.getLastCommittedTransaction();
        long consensusIndex = -1L;
        long timestamp = committedTx.commitTimestamp();
        long upgradeTransactionId = this.store.nextCommittingTransactionId();
        KernelVersion kernelVersion = this.metadataCache.kernelVersion();
        LogFile logFile = logFiles.getLogFile();
        TransactionLogWriter transactionLogWriter = logFile.getTransactionLogWriter();
        CompleteTransaction emptyTx = TransactionLogInitializer.emptyTransaction(timestamp, upgradeTransactionId, kernelVersion, consensusIndex);
        int checksum = transactionLogWriter.append(emptyTx, upgradeTransactionId, 0L, -559063315, LogPosition.UNSPECIFIED);
        logFile.forceAfterAppend(LogAppendEvent.NULL);
        LogPosition position = transactionLogWriter.getCurrentPosition();
        TransactionLogInitializer.appendCheckpoint(logFiles, reason, position, new TransactionId(upgradeTransactionId, checksum, timestamp, consensusIndex), kernelVersion);
        this.store.transactionCommitted(upgradeTransactionId, checksum, timestamp, consensusIndex);
        return upgradeTransactionId;
    }

    private static CompleteTransaction emptyTransaction(long timestamp, long txId, KernelVersion kernelVersion, long consensusIndex) {
        return new CompleteTransaction(Collections.emptyList(), consensusIndex, timestamp, txId, timestamp, -1, kernelVersion, Subject.ANONYMOUS);
    }

    private static void appendCheckpoint(LogFiles logFiles, String reason, LogPosition position, TransactionId transactionId, KernelVersion version) throws IOException {
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, version, position, Instant.now(), reason);
    }
}

