/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Set;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexConfig;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.ReadBehaviour;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.ExternallyManagedPageCache;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.SchemaMigrator;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.Index44Compatibility;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class AcrossEngineMigrationParticipant
extends AbstractStoreMigrationParticipant {
    public static final String NAME = "Store files";
    private final Config config;
    private final LogService logService;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final JobScheduler jobScheduler;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final StorageEngineFactory srcStorageEngine;
    private final StorageEngineFactory targetStorageEngine;
    private final boolean forceBtreeIndexesToRange;

    public AcrossEngineMigrationParticipant(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, LogService logService, JobScheduler jobScheduler, CursorContextFactory contextFactory, MemoryTracker memoryTracker, StorageEngineFactory srcStorageEngine, StorageEngineFactory targetStorageEngine, boolean forceBtreeIndexesToRange) {
        super(NAME);
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.jobScheduler = jobScheduler;
        this.pageCacheTracer = pageCacheTracer;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.srcStorageEngine = srcStorageEngine;
        this.targetStorageEngine = targetStorageEngine;
        this.forceBtreeIndexesToRange = forceBtreeIndexesToRange;
    }

    public void migrate(DatabaseLayout directoryLayoutArg, DatabaseLayout migrationLayoutArg, ProgressListener progressListener, StoreVersion fromVersion, StoreVersion toVersion, IndexImporterFactory indexImporterFactory, LogTailMetadata tailMetadata) throws IOException, KernelException {
        Config localConfig = Config.newBuilder().fromConfig(this.config).set(GraphDatabaseSettings.db_format, (Object)toVersion.formatName()).build();
        AdditionalInitialIds additionalInitialIds = AcrossEngineMigrationParticipant.getInitialIds(tailMetadata);
        BatchImporter importer = this.targetStorageEngine.batchImporter(migrationLayoutArg, this.fileSystem, this.pageCacheTracer, (Configuration)new Configuration.Overridden(Configuration.defaultConfiguration()){

            public IndexConfig indexConfig() {
                return IndexConfig.create().withLabelIndex().withRelationshipTypeIndex();
            }

            public ExternallyManagedPageCache providedPageCache() {
                return new ExternallyManagedPageCache(AcrossEngineMigrationParticipant.this.pageCache);
            }
        }, this.logService, new PrintStream(OutputStream.nullOutputStream()), false, additionalInitialIds, localConfig, this.progressTrackingMonitor(progressListener), this.jobScheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), indexImporterFactory, this.memoryTracker, this.contextFactory);
        try (Input fromInput = this.srcStorageEngine.asBatchImporterInput(directoryLayoutArg, this.fileSystem, this.pageCache, this.pageCacheTracer, localConfig, this.memoryTracker, ReadBehaviour.INCLUSIVE_STRICT, false, this.contextFactory, tailMetadata);){
            importer.doImport(fromInput);
        }
        SchemaMigrator.migrateSchemaRules(this.srcStorageEngine, this.targetStorageEngine, this.fileSystem, this.pageCache, this.pageCacheTracer, localConfig, directoryLayoutArg, migrationLayoutArg, fromVersion.hasCapability((Capability)Index44Compatibility.INSTANCE), this.contextFactory, tailMetadata, this.forceBtreeIndexesToRange);
    }

    private Monitor progressTrackingMonitor(final ProgressListener progressReporter) {
        return new Monitor(){
            private int lastReportedPercentage;

            public void percentageCompleted(int percentage) {
                int diff = percentage - this.lastReportedPercentage;
                if (diff > 0) {
                    progressReporter.add((long)diff);
                    this.lastReportedPercentage = percentage;
                }
            }
        };
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayoutArg, DatabaseLayout directoryLayoutArg, StoreVersion versionToUpgradeFrom, StoreVersion versionToUpgradeTo) throws IOException {
        Path indexFolder;
        DatabaseLayout mig = this.targetStorageEngine.formatSpecificDatabaseLayout(migrationLayoutArg);
        DatabaseLayout dir = this.srcStorageEngine.formatSpecificDatabaseLayout(directoryLayoutArg);
        Path toplevelIndexFolder = indexFolder = IndexDirectoryStructure.baseSchemaIndexFolder((Path)dir.databaseDirectory());
        while (!toplevelIndexFolder.getParent().equals(dir.databaseDirectory())) {
            toplevelIndexFolder = toplevelIndexFolder.getParent();
        }
        Path profiles = dir.databaseDirectory().resolve("profiles");
        MutableSet storeFiles = Sets.mutable.of((Object[])dir.storeFiles().toArray(new Path[0]));
        Set idFiles = dir.idFiles();
        storeFiles.addAll(idFiles);
        storeFiles.add(toplevelIndexFolder);
        storeFiles.add(profiles);
        StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.DELETE_INCLUDING_DIRS, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)dir, (DatabaseLayout)mig, (Path[])storeFiles.toArray(new Path[0]), (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.OVERWRITE);
        Path migIndexFolder = IndexDirectoryStructure.baseSchemaIndexFolder((Path)mig.databaseDirectory());
        storeFiles = Sets.mutable.of((Object[])mig.storeFiles().toArray(new Path[0]));
        idFiles = mig.idFiles();
        storeFiles.addAll(idFiles);
        StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.MOVE, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)mig, (DatabaseLayout)dir, (Path[])storeFiles.toArray(new Path[0]), (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.OVERWRITE);
        this.fileSystem.moveToDirectory(migIndexFolder, indexFolder.getParent());
    }

    public void postMigration(DatabaseLayout databaseLayout, StoreVersion toVersion, long txIdBeforeMigration, long txIdAfterMigration) throws IOException {
    }

    public void cleanup(DatabaseLayout migrationLayout) throws IOException {
    }

    private static AdditionalInitialIds getInitialIds(final LogTailMetadata tailMetadata) {
        return new AdditionalInitialIds(){

            public long lastCommittedTransactionId() {
                return tailMetadata.getLastCommittedTransaction().transactionId();
            }

            public int lastCommittedTransactionChecksum() {
                return tailMetadata.getLastCommittedTransaction().checksum();
            }

            public long lastCommittedTransactionLogVersion() {
                return tailMetadata.getLastTransactionLogPosition().getLogVersion();
            }

            public long lastCommittedTransactionLogByteOffset() {
                return tailMetadata.getLastTransactionLogPosition().getByteOffset();
            }

            public long checkpointLogVersion() {
                return tailMetadata.getCheckpointLogVersion();
            }
        };
    }
}

