/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursorImpl;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class DefaultPropertyCursor
extends TraceableCursorImpl<DefaultPropertyCursor>
implements PropertyCursor,
Supplier<TokenSet>,
RelTypeSupplier {
    private static final int NODE = -2;
    final StoragePropertyCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private Read read;
    private StoragePropertyCursor securityPropertyCursor;
    private FullAccessNodeCursor securityNodeCursor;
    private FullAccessRelationshipScanCursor securityRelCursor;
    private EntityState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private long entityReference = -1L;
    private TokenSet labels;
    private int type = -1;
    private boolean addedInTx;
    private PropertySelection selection;
    private ReadSecurityPropertyProvider securityPropertyProvider;

    DefaultPropertyCursor(CursorPool<DefaultPropertyCursor> pool, StoragePropertyCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool);
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    void initNode(long nodeReference, Reference reference, PropertySelection selection, Read read) {
        assert (nodeReference != -1L);
        this.init(selection, read);
        this.type = -2;
        this.initializeNodeTransactionState(nodeReference, read);
        this.storeCursor.initNodeProperties(reference, this.filterSelectionForTxState(selection));
        this.initSecurityPropertyProvision((propertyCursor, propertySelection) -> propertyCursor.initNodeProperties(reference, propertySelection));
        this.entityReference = nodeReference;
    }

    void initNode(DefaultNodeCursor nodeCursor, PropertySelection selection, Read read, boolean initStoreCursor) {
        this.entityReference = nodeCursor.nodeReference();
        assert (this.entityReference != -1L);
        this.init(selection, read);
        this.type = -2;
        this.addedInTx = nodeCursor.currentNodeIsAddedInTx();
        this.initializeNodeTransactionState(this.entityReference, read);
        if (!this.addedInTx) {
            if (initStoreCursor) {
                this.storeCursor.initNodeProperties(nodeCursor.storeCursor, this.filterSelectionForTxState(selection));
            }
            this.initSecurityPropertyProvision((propertyCursor, propertySelection) -> propertyCursor.initNodeProperties(nodeCursor.storeCursor, propertySelection));
        } else {
            this.storeCursor.reset();
            this.securityPropertyProvider = null;
        }
    }

    private PropertySelection filterSelectionForTxState(PropertySelection selection) {
        return this.propertiesState == null || this.propertiesState == EntityState.EMPTY ? selection : selection.excluding(k -> this.propertiesState.isPropertyChangedOrRemoved(k));
    }

    void initSecurityPropertyProvision(BiConsumer<StoragePropertyCursor, PropertySelection> initNodeProperties) {
        AccessMode accessMode = this.read.getAccessMode();
        this.securityPropertyProvider = null;
        if (this.internalCursors == null || !accessMode.hasPropertyReadRules()) {
            return;
        }
        PropertySelection securityProperties = accessMode.getSecurityPropertySelection(this.selection);
        if (securityProperties == null) {
            return;
        }
        initNodeProperties.accept(this.lazyInitAndGetSecurityPropertyCursor(), securityProperties);
        this.securityPropertyProvider = new ReadSecurityPropertyProvider.LazyReadSecurityPropertyProvider(this.securityPropertyCursor);
    }

    private StoragePropertyCursor lazyInitAndGetSecurityPropertyCursor() {
        if (this.securityPropertyCursor == null) {
            this.securityPropertyCursor = this.internalCursors.allocateStoragePropertyCursor();
        }
        return this.securityPropertyCursor;
    }

    private void initializeNodeTransactionState(long nodeReference, Read read) {
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties().iterator();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initRelationship(long relationshipReference, Reference reference, PropertySelection selection, Read read) {
        assert (relationshipReference != -1L);
        this.init(selection, read);
        this.initializeRelationshipTransactionState(relationshipReference, read);
        this.storeCursor.initRelationshipProperties(reference, this.filterSelectionForTxState(selection));
        this.entityReference = relationshipReference;
    }

    void initRelationship(DefaultRelationshipCursor relationshipCursor, PropertySelection selection, Read read) {
        this.entityReference = relationshipCursor.relationshipReference();
        assert (this.entityReference != -1L);
        this.init(selection, read);
        this.initializeRelationshipTransactionState(this.entityReference, read);
        this.addedInTx = relationshipCursor.currentRelationshipIsAddedInTx();
        if (!this.addedInTx) {
            this.storeCursor.initRelationshipProperties(relationshipCursor.storeCursor, this.filterSelectionForTxState(selection));
        } else {
            this.storeCursor.reset();
        }
    }

    private void initializeRelationshipTransactionState(long relationshipReference, Read read) {
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties().iterator();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initEmptyRelationship(Read read, AssertOpen assertOpen) {
        this.init(PropertySelection.ALL_PROPERTIES, read);
        this.storeCursor.initRelationshipProperties(LongReference.NULL_REFERENCE, PropertySelection.ALL_PROPERTIES);
        this.entityReference = -1L;
        this.propertiesState = null;
        this.txStateChangedProperties = null;
    }

    private void init(PropertySelection selection, Read read) {
        this.selection = selection;
        this.read = read;
        this.labels = null;
        this.type = -1;
    }

    boolean allowed(int[] propertyKeys, int[] labels) {
        AccessMode accessMode = this.read.getAccessMode();
        if (this.isNode()) {
            return accessMode.allowsReadNodeProperties(() -> Labels.from(labels), propertyKeys, this.securityPropertyProvider);
        }
        for (int propertyKey : propertyKeys) {
            if (accessMode.allowsReadRelationshipProperty((RelTypeSupplier)this, propertyKey)) continue;
            return false;
        }
        return true;
    }

    protected boolean allowed(int propertyKey) {
        AccessMode accessMode = this.read.getAccessMode();
        if (this.isNode()) {
            return accessMode.allowsReadNodeProperty((Supplier)this, propertyKey, this.securityPropertyProvider);
        }
        return accessMode.allowsReadRelationshipProperty((RelTypeSupplier)this, propertyKey);
    }

    public boolean next() {
        if (this.txStateChangedProperties != null) {
            while (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                if (!this.selection.test(this.txStateValue.propertyKeyId())) continue;
                if (this.tracer != null) {
                    this.tracer.onProperty(this.txStateValue.propertyKeyId());
                }
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (this.storeCursor.next()) {
            int propertyKey = this.storeCursor.propertyKey();
            if (!this.allowed(propertyKey)) continue;
            if (this.tracer != null) {
                this.tracer.onProperty(propertyKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.storeCursor.reset();
            if (this.securityPropertyCursor != null) {
                this.securityPropertyCursor.reset();
            }
            this.securityPropertyProvider = null;
        }
        super.closeInternal();
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return this.storeCursor.propertyKey();
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        return this.storeCursor.propertyType();
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        Value value = this.storeCursor.propertyValue();
        this.read.assertOpen();
        return value;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.propertyKey() + ", " + this.storeCursor + " ]";
    }

    @Override
    public TokenSet get() {
        assert (this.isNode());
        if (this.labels == null) {
            if (this.securityNodeCursor == null) {
                this.securityNodeCursor = this.internalCursors.allocateFullAccessNodeCursor();
            }
            this.read.singleNode(this.entityReference, this.securityNodeCursor);
            this.securityNodeCursor.next();
            this.labels = this.securityNodeCursor.labelsIgnoringTxStateSetRemove();
        }
        return this.labels;
    }

    public int getRelType() {
        assert (this.isRelationship());
        if (this.type < 0) {
            if (this.securityRelCursor == null) {
                this.securityRelCursor = this.internalCursors.allocateFullAccessRelationshipScanCursor();
            }
            this.read.singleRelationship(this.entityReference, this.securityRelCursor);
            this.securityRelCursor.next();
            this.type = this.securityRelCursor.type();
        }
        return this.type;
    }

    @Override
    public void release() {
        if (this.storeCursor != null) {
            this.storeCursor.close();
        }
        if (this.securityPropertyCursor != null) {
            this.securityPropertyCursor.close();
            this.securityPropertyCursor = null;
        }
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
        if (this.securityRelCursor != null) {
            this.securityRelCursor.close();
            this.securityRelCursor.release();
            this.securityRelCursor = null;
        }
    }

    private boolean isNode() {
        return this.type == -2;
    }

    private boolean isRelationship() {
        return this.type != -2;
    }
}

