/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.nio.file.Path;
import java.util.function.Predicate;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexProvider;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;

public class NativeIndexFileFilter
implements Predicate<Path> {
    private final Path indexRoot;

    public NativeIndexFileFilter(Path storeDir) {
        this.indexRoot = IndexDirectoryStructure.baseSchemaIndexFolder((Path)storeDir).toAbsolutePath();
    }

    @Override
    public boolean test(Path path) {
        if (!path.toAbsolutePath().startsWith(this.indexRoot)) {
            return false;
        }
        Path schemaPath = this.indexRoot.relativize(path);
        int nameCount = schemaPath.getNameCount();
        if (nameCount == 0) {
            return false;
        }
        String schemaBaseName = schemaPath.getName(0).toString();
        boolean isLuceneBackedTextIndex = schemaBaseName.equals(TextIndexProvider.DESCRIPTOR.name()) || schemaBaseName.equals(TrigramIndexProvider.DESCRIPTOR.name()) || schemaBaseName.equals(VectorIndexProvider.DESCRIPTOR.name()) || schemaBaseName.equals(FulltextIndexProviderFactory.DESCRIPTOR.name());
        return !isLuceneBackedTextIndex;
    }
}

