/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.monitor;

import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public abstract class TransactionMonitor<T extends MonitoredTransaction>
implements Runnable {
    private final Config config;
    private final SystemNanoClock clock;
    private final InternalLog log;

    public TransactionMonitor(Config config, SystemNanoClock clock, LogService logService) {
        this.config = config;
        this.clock = clock;
        this.log = logService.getInternalLog(TransactionMonitor.class);
    }

    @Override
    public void run() {
        this.checkActiveTransactions(this.getActiveTransactions(), this.clock.nanos());
        this.updateTransactionBoundaries();
    }

    protected void updateTransactionBoundaries() {
    }

    protected abstract Set<T> getActiveTransactions();

    private void checkExpiredTransaction(T transaction, long nowNanos) {
        long transactionTimeoutNanos = transaction.timeout().timeout().toNanos();
        if (transactionTimeoutNanos > 0L && TransactionMonitor.isTransactionExpired(transaction, nowNanos, transactionTimeoutNanos) && !transaction.isSchemaTransaction() && transaction.markForTermination(transaction.timeout().timoutStatus())) {
            this.log.warn("Transaction %s timeout.", new Object[]{transaction.getIdentifyingDescription()});
        }
    }

    private void checkStaleTerminatedTransaction(MonitoredTransaction transaction, long nowNanos, long terminationTimeoutNanos) {
        transaction.terminationMark().ifPresent(mark -> {
            if (mark.isMarkedAsStale()) {
                return;
            }
            long nanosSinceTermination = nowNanos - mark.getTimestampNanos();
            if (nanosSinceTermination >= terminationTimeoutNanos) {
                this.log.warn("Transaction %s has been marked for termination for %d seconds; it may have been leaked. %s", new Object[]{transaction.getIdentifyingDescription(), TimeUnit.NANOSECONDS.toSeconds(nanosSinceTermination), TransactionMonitor.buildTraceOrHelpMessage(transaction.transactionInitialisationTrace())});
                mark.markAsStale();
            }
        });
    }

    private static String buildTraceOrHelpMessage(TransactionInitializationTrace initializationTrace) {
        String trace = initializationTrace.getTrace();
        if (StringUtils.isEmpty((CharSequence)trace)) {
            return "For a transaction initialization trace, set '%s=ALL'.".formatted(GraphDatabaseSettings.transaction_tracing_level.name());
        }
        return "Initialization trace:%n%s".formatted(trace);
    }

    private void checkActiveTransactions(Set<T> activeTransactions, long nowNanos) {
        long terminationTimeoutNanos = ((Duration)this.config.get(GraphDatabaseInternalSettings.transaction_termination_timeout)).toNanos();
        for (MonitoredTransaction activeTransaction : activeTransactions) {
            this.checkExpiredTransaction(activeTransaction, nowNanos);
            if (terminationTimeoutNanos <= 0L) continue;
            this.checkStaleTerminatedTransaction(activeTransaction, nowNanos, terminationTimeoutNanos);
        }
    }

    private static boolean isTransactionExpired(MonitoredTransaction activeTransaction, long nowNanos, long transactionTimeoutNanos) {
        return nowNanos - activeTransaction.startTimeNanos() > transactionTimeoutNanos;
    }

    public static interface MonitoredTransaction {
        public long startTimeNanos();

        public TransactionTimeout timeout();

        public boolean isSchemaTransaction();

        public Optional<TerminationMark> terminationMark();

        public boolean markForTermination(Status var1);

        public String getIdentifyingDescription();

        public TransactionInitializationTrace transactionInitialisationTrace();
    }
}

