/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class ConcurrentBag<T> {
    private static final AtomicReferenceFieldUpdater<ConcurrentBag, Node> UPDATE_TAIL = AtomicReferenceFieldUpdater.newUpdater(ConcurrentBag.class, Node.class, "tail");
    private static final AtomicReferenceFieldUpdater<Node, Node> UPDATE_NODE = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
    public static final long SIZE_OF_NODE = HeapEstimator.shallowSizeOfInstance(Node.class);
    static final long SIZE_OF_BAG = HeapEstimator.shallowSizeOfInstance(ConcurrentBag.class) + SIZE_OF_NODE;
    private final Node head;
    private volatile Node tail;

    public static <T> ConcurrentBag<T> newBag(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SIZE_OF_BAG);
        return new ConcurrentBag<T>();
    }

    public ConcurrentBag() {
        Node node;
        this.head = node = new Node(null);
        this.tail = node;
    }

    public void add(T value) {
        Node node = new Node(value);
        while (true) {
            Node last = this.tail;
            Node next = last.next;
            if (last != this.tail) continue;
            if (next == null) {
                if (!UPDATE_NODE.compareAndSet(last, null, node)) continue;
                UPDATE_TAIL.compareAndSet(this, last, node);
                return;
            }
            UPDATE_TAIL.compareAndSet(this, last, next);
        }
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Node current;
            {
                this.current = ConcurrentBag.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current.next != null;
            }

            @Override
            public T next() {
                this.current = this.current.next;
                return this.current.value;
            }
        };
    }

    static class Node {
        private final Object value;
        volatile Node next;

        Node(Object value) {
            this.value = value;
            this.next = null;
        }

        boolean compareAndSetNext(Node newNode) {
            return UPDATE_NODE.compareAndSet(this, null, newNode);
        }
    }
}

