/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.storemigration.AcrossEngineMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.AcrossEngineVersionCheck;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.MigrationStoreVersionCheck;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.util.Preconditions;

public class StorageEngineMigrationAbstraction {
    private final StorageEngineFactory storageEngineFactory;
    private final StorageEngineFactory targetStorageEngineFactory;
    private final boolean migrationAcrossEngine;

    StorageEngineMigrationAbstraction(StorageEngineFactory storageEngineFactory, StorageEngineFactory targetStorageEngineFactory) {
        this.storageEngineFactory = storageEngineFactory;
        this.targetStorageEngineFactory = targetStorageEngineFactory;
        this.migrationAcrossEngine = storageEngineFactory.id() != targetStorageEngineFactory.id();
    }

    StorageEngineFactory getStorageEngineFactory() {
        return this.storageEngineFactory;
    }

    StorageEngineFactory getTargetStorageEngineFactory() {
        return this.targetStorageEngineFactory;
    }

    MigrationStoreVersionCheck getStoreVersionCheck(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, Config config, LogService logService, CursorContextFactory contextFactory) {
        return this.migrationAcrossEngine ? new AcrossEngineVersionCheck(fs, pageCache, databaseLayout, config, logService, contextFactory, this.storageEngineFactory, this.targetStorageEngineFactory) : this.storageEngineFactory.versionCheck(fs, databaseLayout, config, pageCache, logService, contextFactory);
    }

    List<StoreMigrationParticipant> getMigrationParticipants(boolean forceBtreeIndexesToRange, FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, LogService logService, JobScheduler jobScheduler, CursorContextFactory contextFactory, MemoryTracker memoryTracker, IndexProviderMap indexProviderMap) {
        ArrayList<StoreMigrationParticipant> storeParticipants = new ArrayList<StoreMigrationParticipant>();
        if (this.migrationAcrossEngine) {
            storeParticipants.add((StoreMigrationParticipant)new AcrossEngineMigrationParticipant(fs, pageCache, pageCacheTracer, config, logService, jobScheduler, contextFactory, memoryTracker, this.storageEngineFactory, this.targetStorageEngineFactory));
        } else {
            storeParticipants.addAll(this.storageEngineFactory.migrationParticipants(fs, config, pageCache, jobScheduler, logService, memoryTracker, pageCacheTracer, contextFactory, forceBtreeIndexesToRange));
            indexProviderMap.accept(provider -> storeParticipants.add(provider.storeMigrationParticipant(fs, pageCache, pageCacheTracer, this.storageEngineFactory, contextFactory)));
        }
        HashSet participantNames = new HashSet();
        storeParticipants.forEach(participant -> {
            if (!StoreMigrationParticipant.NOT_PARTICIPATING.equals(participant)) {
                String newParticipantName = participant.getName();
                Preconditions.checkState((!participantNames.contains(newParticipantName) ? 1 : 0) != 0, (String)"Migration participants should have unique names. Participant with name: '%s' is already registered.", (Object[])new Object[]{newParticipantName});
                participantNames.add(newParticipantName);
            }
        });
        return storeParticipants;
    }
}

