/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.FileURLAccessRule;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class URLAccessRules {
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final Map<String, URLAccessRule> rules;
    private final WebURLAccessRule webAccess;
    private static final FileURLAccessRule FILE_ACCESS = new FileURLAccessRule();

    public URLAccessRules(AbstractSecurityLog securityLog, Configuration configuration) {
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        this.webAccess = new WebURLAccessRule(configuration);
        this.rules = new HashMap<String, URLAccessRule>();
        this.rules.put("http", this.webAccess);
        this.rules.put("https", this.webAccess);
        this.rules.put("ftp", this.webAccess);
        this.rules.put("file", FILE_ACCESS);
    }

    public static URLAccessRule fileAccess() {
        return FILE_ACCESS;
    }

    public WebURLAccessRule webAccess() {
        return this.webAccess;
    }

    public URL validate(Configuration configuration, SecurityContext securityContext, URL url) throws URLAccessValidationError {
        this.securityAuthorizationHandler.assertLoadAllowed(securityContext, url);
        String protocol = url.getProtocol();
        URLAccessRule protocolRule = this.rules.get(protocol);
        if (protocolRule == null) {
            throw new URLAccessValidationError("loading resources via protocol '" + protocol + "' is not permitted");
        }
        return protocolRule.validate(configuration, url);
    }
}

