/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointIndexReader;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.SpatialConfigVisitor;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class PointBlockBasedIndexPopulator
extends BlockBasedIndexPopulator<PointKey> {
    private final IndexSpecificSpaceFillingCurveSettings spatialSettings;
    private final SpaceFillingCurveConfiguration configuration;

    PointBlockBasedIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<PointKey> layout, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spatialSettings, SpaceFillingCurveConfiguration configuration, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, Config config, MemoryTracker memoryTracker, BlockBasedIndexPopulator.Monitor monitor, ImmutableSet<OpenOption> openOptions) {
        super(databaseIndexContext, indexFiles, layout, descriptor, archiveFailedIndex, bufferFactory, config, memoryTracker, monitor, openOptions);
        this.spatialSettings = spatialSettings;
        this.configuration = configuration;
    }

    @Override
    protected IndexValueValidator instantiateValueValidator() {
        return IndexValueValidator.NO_VALIDATION;
    }

    @Override
    NativeIndexReader<PointKey> newReader() {
        return new PointIndexReader((GBPTree<PointKey, NullValue>)this.tree, this.layout, this.descriptor, this.spatialSettings, this.configuration, IndexUsageTracker.NO_USAGE_TRACKER);
    }

    @Override
    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return PointIndexProvider.UPDATE_IGNORE_STRATEGY;
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        this.spatialSettings.visitIndexSpecificSettings(new SpatialConfigVisitor(map));
        return map;
    }
}

