/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.collection.diffset.MutableLongDiffSets;
import org.neo4j.collection.diffset.TrackableDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.state.AppendOnlyValuesContainer;
import org.neo4j.kernel.impl.api.state.ValuesContainer;
import org.neo4j.kernel.impl.api.state.ValuesMap;
import org.neo4j.kernel.impl.util.collection.LinearProbeLongLongHashMap;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.kernel.impl.util.collection.MutableLinearProbeLongHashSet;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapMemoryAllocator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class OffHeapCollectionsFactory
implements CollectionsFactory {
    private final MemoryAllocator allocator;
    private final Collection<Resource> resources = new ArrayList<Resource>();
    private ValuesContainer valuesContainer;

    public OffHeapCollectionsFactory(OffHeapBlockAllocator blockAllocator) {
        this.allocator = new OffHeapMemoryAllocator(blockAllocator);
    }

    public MutableLongSet newLongSet(MemoryTracker memoryTracker) {
        MutableLinearProbeLongHashSet set = new MutableLinearProbeLongHashSet(this.allocator, memoryTracker);
        this.resources.add(set);
        return set;
    }

    public MutableLongDiffSets newLongDiffSets(MemoryTracker memoryTracker) {
        return TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)this, (MemoryTracker)memoryTracker);
    }

    public MutableLongObjectMap<Value> newObjectMap(MemoryTracker memoryTracker) {
        if (this.valuesContainer == null) {
            this.valuesContainer = new AppendOnlyValuesContainer(this.allocator, memoryTracker);
        }
        LinearProbeLongLongHashMap refs = new LinearProbeLongLongHashMap(this.allocator, memoryTracker);
        this.resources.add(refs);
        return new ValuesMap(refs, this.valuesContainer);
    }

    public void release() {
        this.resources.forEach(Resource::close);
        this.resources.clear();
        if (this.valuesContainer != null) {
            this.valuesContainer.close();
            this.valuesContainer = null;
        }
    }
}

