/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.storemigration.UnableToMigrateException;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.MigrationStoreVersionCheck;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public class AcrossEngineVersionCheck
implements MigrationStoreVersionCheck {
    private final StoreVersionCheck srcVersionCheck;
    private final StoreVersionCheck targetVersionCheck;

    public AcrossEngineVersionCheck(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, Config config, LogService logService, CursorContextFactory contextFactory, StorageEngineFactory srcStorageEngineFactory, StorageEngineFactory targetStorageEngineFactory) {
        this.srcVersionCheck = srcStorageEngineFactory.versionCheck(fs, databaseLayout, config, pageCache, logService, contextFactory);
        this.targetVersionCheck = targetStorageEngineFactory.versionCheck(fs, databaseLayout, config, pageCache, logService, contextFactory);
    }

    public MigrationStoreVersionCheck.MigrationCheckResult getAndCheckMigrationTargetVersion(String formatToMigrateTo, CursorContext cursorContext) {
        StoreVersionIdentifier targetVersion;
        StoreVersionIdentifier currentVersion;
        try {
            currentVersion = this.srcVersionCheck.getCurrentVersion(cursorContext);
        }
        catch (Exception e) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.STORE_VERSION_RETRIEVAL_FAILURE, null, null, e);
        }
        if (!this.srcVersionCheck.isStoreVersionFullySupported(currentVersion, cursorContext)) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_MIGRATION_PATH, currentVersion, null, (Exception)new UnableToMigrateException("Migration directly from " + currentVersion.getStoreVersionUserString() + " not possible. Migrate to a supported replacement first."));
        }
        try {
            targetVersion = this.targetVersionCheck.findLatestVersion(formatToMigrateTo);
        }
        catch (Exception e) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_TARGET_VERSION, currentVersion, null, e);
        }
        if (!this.targetVersionCheck.isStoreVersionFullySupported(targetVersion, cursorContext)) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_TARGET_VERSION, currentVersion, targetVersion, null);
        }
        return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.MIGRATION_POSSIBLE, currentVersion, targetVersion, null);
    }
}

