/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.URL;
import java.util.Map;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.FileURLAccessRule;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class URLAccessRules {
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final Map<String, URLAccessRule> rules;
    private static final URLAccessRule FILE_ACCESS = new FileURLAccessRule();
    private static final URLAccessRule WEB_ACCESS = new WebURLAccessRule();

    public URLAccessRules(AbstractSecurityLog securityLog, Map<String, URLAccessRule> rules) {
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        this.rules = rules;
    }

    public static URLAccessRule fileAccess() {
        return FILE_ACCESS;
    }

    public static URLAccessRule webAccess() {
        return WEB_ACCESS;
    }

    public URL validate(Configuration configuration, SecurityContext securityContext, URL url) throws URLAccessValidationError {
        this.securityAuthorizationHandler.assertLoadAllowed(securityContext, url);
        String protocol = url.getProtocol();
        URLAccessRule protocolRule = this.rules.get(protocol);
        if (protocolRule == null) {
            throw new URLAccessValidationError("loading resources via protocol '" + protocol + "' is not permitted");
        }
        return protocolRule.validate(configuration, url);
    }
}

