/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.Closeable;
import java.util.function.Consumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.values.ElementIdMapper;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    public final KernelTransaction.Type transactionType;
    public final SecurityContext securityContext;
    private final ExecutingQuery executingQuery;
    private final ClientConnectionInfo clientInfo;
    private final NamedDatabaseId namedDatabaseId;
    private final InternalTransaction transaction;
    private KernelTransaction kernelTransaction;
    private KernelStatement statement;
    private QueryRegistry queryRegistry;
    private final ElementIdMapper elementIdMapper;
    private long transactionSequenceNumber;
    private final KernelTransactionFactory transactionFactory;
    private final OnCloseCallback onClose;
    private volatile boolean isOpen = true;
    private StatisticProvider statisticProvider;
    private final QueryExecutionConfiguration queryExecutionConfiguration;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction transaction, KernelStatement initialStatement, ExecutingQuery executingQuery, KernelTransactionFactory transactionFactory, QueryExecutionConfiguration queryExecutionConfiguration) {
        this(graph, transaction, initialStatement, executingQuery, transactionFactory, null, queryExecutionConfiguration);
    }

    private Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction transaction, KernelStatement initialStatement, ExecutingQuery executingQuery, KernelTransactionFactory transactionFactory, OnCloseCallback onClose, QueryExecutionConfiguration queryExecutionConfiguration) {
        this.graph = graph;
        this.transactionType = transaction.transactionType();
        this.securityContext = transaction.securityContext();
        this.clientInfo = transaction.clientInfo();
        this.executingQuery = executingQuery;
        this.transaction = transaction;
        this.namedDatabaseId = initialStatement.namedDatabaseId();
        this.kernelTransaction = transaction.kernelTransaction();
        this.statement = initialStatement;
        this.queryRegistry = this.statement.queryRegistry();
        this.elementIdMapper = transaction.elementIdMapper();
        this.transactionSequenceNumber = this.kernelTransaction.getTransactionSequenceNumber();
        this.transactionFactory = transactionFactory;
        this.statisticProvider = new TransactionalContextStatisticProvider(this.kernelTransaction.executionStatistics());
        this.onClose = onClose;
        this.queryExecutionConfiguration = queryExecutionConfiguration;
    }

    @Override
    public ExecutingQuery executingQuery() {
        return this.executingQuery;
    }

    @Override
    public KernelTransaction kernelTransaction() {
        return this.kernelTransaction;
    }

    @Override
    public InternalTransaction transaction() {
        return this.transaction;
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == KernelTransaction.Type.IMPLICIT;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            try {
                if (this.onClose != null) {
                    this.onClose.close();
                }
                this.beforeUnbind();
                this.queryRegistry.unbindExecutingQuery(this.executingQuery, this.transactionSequenceNumber);
                this.closeStatement();
            }
            finally {
                this.statement = null;
                this.isOpen = false;
            }
        }
    }

    private void closeStatement() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            finally {
                this.statement = null;
            }
        }
    }

    private void beforeUnbind() {
        if (this.statement != null) {
            this.queryRegistry.beforeUnbindExecutingQuery(this.executingQuery, this.transactionSequenceNumber);
        }
    }

    private KernelTransaction.KernelTransactionMonitor statisticsMonitor() {
        return KernelTransaction.KernelTransactionMonitor.withAfterCommit(statistics -> this.executingQuery.recordStatisticsOfClosedTransaction((ExecutionStatistics)statistics));
    }

    @Override
    public void commit() {
        this.safeTxOperation(this::commitOperation);
    }

    private void commitOperation(InternalTransaction tx) {
        tx.commit(this.statisticsMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeTxOperation(Consumer<InternalTransaction> operation) {
        RuntimeException exception = null;
        try {
            this.beforeUnbind();
            this.closeStatement();
            operation.accept(this.transaction);
        }
        catch (RuntimeException e) {
            exception = e;
        }
        finally {
            try {
                this.close();
            }
            catch (RuntimeException e) {
                exception = (RuntimeException)Exceptions.chain((Throwable)exception, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void rollback() {
        this.safeTxOperation(Transaction::rollback);
    }

    @Override
    public void terminate() {
        if (this.isOpen) {
            this.transaction.terminate();
        }
    }

    @Override
    public long commitAndRestartTx() {
        long l;
        block8: {
            this.checkNotTerminated();
            QueryRegistry oldQueryRegistry = this.queryRegistry;
            KernelStatement oldStatement = this.statement;
            KernelTransaction oldKernelTx = this.transaction.kernelTransaction();
            oldQueryRegistry.beforeUnbindExecutingQuery(this.executingQuery, this.transactionSequenceNumber);
            oldQueryRegistry.unbindExecutingQuery(this.executingQuery, this.transactionSequenceNumber);
            this.kernelTransaction = this.transactionFactory.beginKernelTransaction(this.transactionType, (LoginContext)this.securityContext, this.clientInfo, null);
            this.statement = (KernelStatement)this.kernelTransaction.acquireStatement();
            this.queryRegistry = this.statement.queryRegistry();
            this.transactionSequenceNumber = this.kernelTransaction.getTransactionSequenceNumber();
            this.queryRegistry.bindExecutingQuery(this.executingQuery);
            this.transaction.setTransaction(this.kernelTransaction);
            this.updatePeriodicCommitStatisticProvider(this.kernelTransaction);
            oldStatement.close();
            KernelTransaction kernelTransaction = oldKernelTx;
            try {
                l = oldKernelTx.commit(this.statisticsMonitor());
                if (kernelTransaction == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (kernelTransaction != null) {
                        try {
                            kernelTransaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.transaction.rollback();
                    throw new RuntimeException(t);
                }
            }
            kernelTransaction.close();
        }
        return l;
    }

    @Override
    public Neo4jTransactionalContext contextWithNewTransaction() {
        this.checkNotTerminated();
        InternalTransaction newTransaction = null;
        OnCloseCallback onClose = null;
        try {
            newTransaction = this.graph.beginTransaction(this.transactionType, (LoginContext)this.securityContext, this.clientInfo);
            long newTransactionId = newTransaction.kernelTransaction().getTransactionSequenceNumber();
            InnerTransactionHandler innerTransactionHandler = this.kernelTransaction.getInnerTransactionHandler();
            onClose = () -> innerTransactionHandler.removeInnerTransaction(newTransactionId);
            innerTransactionHandler.registerInnerTransaction(newTransactionId);
            KernelStatement newStatement = (KernelStatement)newTransaction.kernelTransaction().acquireStatement();
            newStatement.queryRegistry().bindExecutingQuery(this.executingQuery);
            return new Neo4jTransactionalContext(this.graph, newTransaction, newStatement, this.executingQuery, this.transactionFactory, onClose, this.queryExecutionConfiguration);
        }
        catch (Throwable outer) {
            try {
                IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{onClose, newTransaction});
            }
            catch (Throwable inner) {
                outer.addSuppressed(inner);
            }
            throw outer;
        }
    }

    @Override
    public TransactionalContext getOrBeginNewIfClosed() {
        this.checkNotTerminated();
        if (!this.isOpen) {
            this.statement = (KernelStatement)this.kernelTransaction.acquireStatement();
            this.queryRegistry = this.statement.queryRegistry();
            this.queryRegistry.bindExecutingQuery(this.executingQuery);
            this.isOpen = true;
        }
        return this;
    }

    private void checkNotTerminated() {
        this.transaction.terminationReason().ifPresent(status -> {
            throw new TransactionTerminatedException(status);
        });
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public NamedDatabaseId databaseId() {
        return this.namedDatabaseId;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(SecurityContext context) {
        return this.transaction.overrideWith(context);
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public ResourceTracker resourceTracker() {
        return this.statement;
    }

    @Override
    public ElementIdMapper elementIdMapper() {
        return this.elementIdMapper;
    }

    @Override
    public QueryExecutionConfiguration queryExecutingConfiguration() {
        return this.queryExecutionConfiguration;
    }

    @Override
    public StatisticProvider kernelStatisticProvider() {
        return this.statisticProvider;
    }

    private void updatePeriodicCommitStatisticProvider(KernelTransaction kernelTransaction) {
        this.statisticProvider = new PeriodicCommitTransactionalContextStatisticProvider(kernelTransaction.executionStatistics());
    }

    @FunctionalInterface
    private static interface OnCloseCallback
    extends Closeable {
        @Override
        public void close();
    }

    private class TransactionalContextStatisticProvider
    implements StatisticProvider {
        private final ExecutionStatistics executionStatistics;

        private TransactionalContextStatisticProvider(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
        }

        @Override
        public long getPageCacheHits() {
            return this.executionStatistics.pageHits() + Neo4jTransactionalContext.this.executingQuery.pageHitsOfClosedTransactionCommits();
        }

        @Override
        public long getPageCacheMisses() {
            return this.executionStatistics.pageFaults() + Neo4jTransactionalContext.this.executingQuery.pageFaultsOfClosedTransactionCommits();
        }
    }

    private class PeriodicCommitTransactionalContextStatisticProvider
    implements StatisticProvider {
        private final ExecutionStatistics executionStatistics;

        private PeriodicCommitTransactionalContextStatisticProvider(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
        }

        @Override
        public long getPageCacheHits() {
            return this.executionStatistics.pageHits() + Neo4jTransactionalContext.this.executingQuery.pageHitsOfClosedTransactions();
        }

        @Override
        public long getPageCacheMisses() {
            return this.executionStatistics.pageFaults() + Neo4jTransactionalContext.this.executingQuery.pageFaultsOfClosedTransactions();
        }
    }

    @FunctionalInterface
    static interface Creator {
        public Neo4jTransactionalContext create(InternalTransaction var1, KernelStatement var2, ExecutingQuery var3, QueryExecutionConfiguration var4);
    }
}

