/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.newapi.InternalTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.Read;

public class PartitionedTokenIndexCursorScan<Cursor extends Cursor>
implements PartitionedScan<Cursor> {
    private final Read fallbackRead;
    private final TokenPredicate query;
    private final PartitionedTokenScan tokenScan;

    PartitionedTokenIndexCursorScan(Read read, TokenPredicate query, PartitionedTokenScan tokenScan) {
        if (read.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        this.fallbackRead = read;
        this.query = query;
        this.tokenScan = tokenScan;
    }

    public int getNumberOfPartitions() {
        return this.tokenScan.getNumberOfPartitions();
    }

    public boolean reservePartition(Cursor cursor, CursorContext cursorContext, AccessMode accessMode) {
        return this.reservePartition(cursor, this.fallbackRead, cursorContext, accessMode);
    }

    public boolean reservePartition(Cursor cursor, ExecutionContext executionContext) {
        return this.reservePartition(cursor, (Read)executionContext.dataRead(), executionContext.cursorContext(), executionContext.securityContext().mode());
    }

    private boolean reservePartition(Cursor cursor, Read read, CursorContext cursorContext, AccessMode accessMode) {
        InternalTokenIndexCursor indexCursor = (InternalTokenIndexCursor)cursor;
        indexCursor.setRead(read);
        IndexProgressor indexProgressor = this.tokenScan.reservePartition((IndexProgressor.EntityTokenClient)indexCursor, cursorContext);
        if (indexProgressor == IndexProgressor.EMPTY) {
            return false;
        }
        indexCursor.initialize(indexProgressor, this.query.tokenId(), null, null, accessMode);
        return true;
    }

    PartitionedTokenScan getTokenScan() {
        return this.tokenScan;
    }
}

