/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.InternalRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DefaultPooledCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private final StoreCursors storeCursors;
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private DefaultNodeCursor nodeCursor;
    private FullAccessNodeCursor fullAccessNodeCursor;
    private DefaultRelationshipScanCursor relationshipScanCursor;
    private FullAccessRelationshipScanCursor fullAccessRelationshipScanCursor;
    private DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private FullAccessRelationshipTraversalCursor fullAccessRelationshipTraversalCursor;
    private DefaultPropertyCursor propertyCursor;
    private FullAccessPropertyCursor fullAccessPropertyCursor;
    private DefaultNodeValueIndexCursor nodeValueIndexCursor;
    private FullAccessNodeValueIndexCursor fullAccessNodeValueIndexCursor;
    private FullAccessRelationshipValueIndexCursor fullAccessRelationshipValueIndexCursor;
    private DefaultNodeLabelIndexCursor nodeLabelIndexCursor;
    private DefaultNodeLabelIndexCursor fullAccessNodeLabelIndexCursor;
    private DefaultRelationshipValueIndexCursor relationshipValueIndexCursor;
    private InternalRelationshipTypeIndexCursor relationshipTypeIndexCursor;
    private InternalRelationshipTypeIndexCursor fullAccessRelationshipTypeIndexCursor;

    public DefaultPooledCursors(StorageReader storageReader, StoreCursors storeCursors, Config config, StorageEngineIndexingBehaviour indexingBehaviour) {
        super(new ArrayList<DefaultCursors.CloseableStacktrace>(), config);
        this.storageReader = storageReader;
        this.storeCursors = storeCursors;
        this.indexingBehaviour = indexingBehaviour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeCursor allocateNodeCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeCursor == null) {
            return this.trace(new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext, this.storeCursors), this.newInternalCursors(cursorContext, memoryTracker)));
        }
        try {
            DefaultNodeCursor defaultNodeCursor = DefaultPooledCursors.acquire(this.nodeCursor);
            return defaultNodeCursor;
        }
        finally {
            this.nodeCursor = null;
        }
    }

    private void accept(DefaultNodeCursor cursor) {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        cursor.removeTracer();
        this.nodeCursor = cursor;
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor(CursorContext cursorContext) {
        if (this.fullAccessNodeCursor == null) {
            return this.trace(new FullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor(cursorContext, this.storeCursors)));
        }
        try {
            FullAccessNodeCursor fullAccessNodeCursor = DefaultPooledCursors.acquire(this.fullAccessNodeCursor);
            return fullAccessNodeCursor;
        }
        finally {
            this.fullAccessNodeCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeCursor cursor) {
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeCursor = (FullAccessNodeCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipScanCursor == null) {
            return this.trace(new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors), this.newInternalCursors(cursorContext, memoryTracker)));
        }
        try {
            DefaultRelationshipScanCursor defaultRelationshipScanCursor = DefaultPooledCursors.acquire(this.relationshipScanCursor);
            return defaultRelationshipScanCursor;
        }
        finally {
            this.relationshipScanCursor = null;
        }
    }

    private void accept(DefaultRelationshipScanCursor cursor) {
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.relationshipScanCursor = cursor;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor(CursorContext cursorContext) {
        if (this.fullAccessRelationshipScanCursor == null) {
            return this.trace(new FullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors)));
        }
        try {
            RelationshipScanCursor relationshipScanCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipScanCursor);
            return relationshipScanCursor;
        }
        finally {
            this.fullAccessRelationshipScanCursor = null;
        }
    }

    private static <C extends TraceableCursor> C acquire(C cursor) {
        cursor.acquire();
        return cursor;
    }

    private void acceptFullAccess(DefaultRelationshipScanCursor cursor) {
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipScanCursor = (FullAccessRelationshipScanCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipTraversalCursor == null) {
            return this.trace(new DefaultRelationshipTraversalCursor(this::accept, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors), this.newInternalCursors(cursorContext, memoryTracker)));
        }
        try {
            DefaultRelationshipTraversalCursor defaultRelationshipTraversalCursor = DefaultPooledCursors.acquire(this.relationshipTraversalCursor);
            return defaultRelationshipTraversalCursor;
        }
        finally {
            this.relationshipTraversalCursor = null;
        }
    }

    void accept(DefaultRelationshipTraversalCursor cursor) {
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTraversalCursor = cursor;
    }

    public RelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(CursorContext cursorContext) {
        if (this.fullAccessRelationshipTraversalCursor == null) {
            return this.trace(new FullAccessRelationshipTraversalCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors)));
        }
        try {
            RelationshipTraversalCursor relationshipTraversalCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipTraversalCursor);
            return relationshipTraversalCursor;
        }
        finally {
            this.fullAccessRelationshipTraversalCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipTraversalCursor cursor) {
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipTraversalCursor = (FullAccessRelationshipTraversalCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPropertyCursor allocatePropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.propertyCursor == null) {
            return this.trace(new DefaultPropertyCursor(this::accept, this.storageReader.allocatePropertyCursor(cursorContext, this.storeCursors, memoryTracker), this.newInternalCursors(cursorContext, memoryTracker)));
        }
        try {
            DefaultPropertyCursor defaultPropertyCursor = DefaultPooledCursors.acquire(this.propertyCursor);
            return defaultPropertyCursor;
        }
        finally {
            this.propertyCursor = null;
        }
    }

    private void accept(DefaultPropertyCursor cursor) {
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        cursor.removeTracer();
        this.propertyCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessPropertyCursor allocateFullAccessPropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessPropertyCursor == null) {
            return this.trace(new FullAccessPropertyCursor(this::acceptFullAccess, this.storageReader.allocatePropertyCursor(cursorContext, this.storeCursors, memoryTracker)));
        }
        try {
            FullAccessPropertyCursor fullAccessPropertyCursor = DefaultPooledCursors.acquire(this.fullAccessPropertyCursor);
            return fullAccessPropertyCursor;
        }
        finally {
            this.fullAccessPropertyCursor = null;
        }
    }

    private void acceptFullAccess(DefaultPropertyCursor cursor) {
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessPropertyCursor = (FullAccessPropertyCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeValueIndexCursor allocateNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeValueIndexCursor == null) {
            return this.trace(new DefaultNodeValueIndexCursor(this::accept, this.newInternalCursors(cursorContext, memoryTracker)));
        }
        try {
            DefaultNodeValueIndexCursor defaultNodeValueIndexCursor = DefaultPooledCursors.acquire(this.nodeValueIndexCursor);
            return defaultNodeValueIndexCursor;
        }
        finally {
            this.nodeValueIndexCursor = null;
        }
    }

    private void accept(DefaultNodeValueIndexCursor cursor) {
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessNodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessNodeValueIndexCursor == null) {
            return this.trace(new FullAccessNodeValueIndexCursor(this::acceptFullAccess));
        }
        try {
            FullAccessNodeValueIndexCursor fullAccessNodeValueIndexCursor = DefaultPooledCursors.acquire(this.fullAccessNodeValueIndexCursor);
            return fullAccessNodeValueIndexCursor;
        }
        finally {
            this.fullAccessNodeValueIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeValueIndexCursor cursor) {
        if (this.fullAccessNodeValueIndexCursor != null) {
            this.fullAccessNodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeValueIndexCursor = (FullAccessNodeValueIndexCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessRelationshipValueIndexCursor allocateFullAccessRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessRelationshipValueIndexCursor == null) {
            return this.trace(new FullAccessRelationshipValueIndexCursor(this::acceptFullAccess));
        }
        try {
            FullAccessRelationshipValueIndexCursor fullAccessRelationshipValueIndexCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipValueIndexCursor);
            return fullAccessRelationshipValueIndexCursor;
        }
        finally {
            this.fullAccessRelationshipValueIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipValueIndexCursor cursor) {
        if (this.fullAccessRelationshipValueIndexCursor != null) {
            this.fullAccessRelationshipValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipValueIndexCursor = (FullAccessRelationshipValueIndexCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeLabelIndexCursor allocateNodeLabelIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeLabelIndexCursor == null) {
            return this.trace(new DefaultNodeLabelIndexCursor(this::accept, this.newInternalCursors(cursorContext, memoryTracker)));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = DefaultPooledCursors.acquire(this.nodeLabelIndexCursor);
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.nodeLabelIndexCursor = null;
        }
    }

    private void accept(DefaultNodeLabelIndexCursor cursor) {
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeLabelIndexCursor = cursor;
    }

    public DefaultNodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(CursorContext cursorContext) {
        if (this.fullAccessNodeLabelIndexCursor == null) {
            return this.trace(new FullAccessNodeLabelIndexCursor(this::acceptFullAccess));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = DefaultPooledCursors.acquire(this.fullAccessNodeLabelIndexCursor);
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.fullAccessNodeLabelIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeLabelIndexCursor cursor) {
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        this.fullAccessNodeLabelIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipValueIndexCursor allocateRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipValueIndexCursor == null) {
            InternalCursorFactory internalCursors = this.newInternalCursors(cursorContext, memoryTracker);
            DefaultRelationshipScanCursor relationshipScanCursor = new DefaultRelationshipScanCursor(c -> {}, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors), internalCursors);
            return this.trace(new DefaultRelationshipValueIndexCursor(this::accept, relationshipScanCursor, internalCursors));
        }
        try {
            RelationshipValueIndexCursor relationshipValueIndexCursor = DefaultPooledCursors.acquire(this.relationshipValueIndexCursor);
            return relationshipValueIndexCursor;
        }
        finally {
            this.relationshipValueIndexCursor = null;
        }
    }

    public void accept(DefaultRelationshipValueIndexCursor cursor) {
        if (this.relationshipValueIndexCursor != null) {
            this.relationshipValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipTypeIndexCursor == null) {
            InternalCursorFactory internalCursors = this.newInternalCursors(cursorContext, memoryTracker);
            if (this.indexingBehaviour.useNodeIdsInRelationshipTokenIndex()) {
                DefaultRelationshipTraversalCursor relationshipTraversalCursor = new DefaultRelationshipTraversalCursor(c -> {}, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors), internalCursors);
                return this.trace(new DefaultNodeBasedRelationshipTypeIndexCursor(this::accept, internalCursors.allocateNodeCursor(), relationshipTraversalCursor));
            }
            DefaultRelationshipScanCursor relationshipScanCursor = new DefaultRelationshipScanCursor(c -> {}, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors), internalCursors);
            return this.trace(new DefaultRelationshipBasedRelationshipTypeIndexCursor(this::accept, relationshipScanCursor));
        }
        try {
            RelationshipTypeIndexCursor relationshipTypeIndexCursor = DefaultPooledCursors.acquire(this.relationshipTypeIndexCursor);
            return relationshipTypeIndexCursor;
        }
        finally {
            this.relationshipTypeIndexCursor = null;
        }
    }

    private void accept(InternalRelationshipTypeIndexCursor cursor) {
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTypeIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTypeIndexCursor allocateFullAccessRelationshipTypeIndexCursor(CursorContext cursorContext) {
        if (this.fullAccessRelationshipTypeIndexCursor == null) {
            if (this.indexingBehaviour.useNodeIdsInRelationshipTokenIndex()) {
                FullAccessNodeCursor nodeCursor = new FullAccessNodeCursor(c -> {}, this.storageReader.allocateNodeCursor(cursorContext, this.storeCursors));
                FullAccessRelationshipTraversalCursor relationshipTraversalCursor = new FullAccessRelationshipTraversalCursor(c -> {}, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors));
                return this.trace(new DefaultNodeBasedRelationshipTypeIndexCursor(this::acceptFullAccess, nodeCursor, relationshipTraversalCursor));
            }
            FullAccessRelationshipScanCursor relationshipScanCursor = new FullAccessRelationshipScanCursor(c -> {}, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors));
            return this.trace(new FullAccessRelationshipBasedRelationshipTypeIndexCursor(this::acceptFullAccess, relationshipScanCursor));
        }
        try {
            RelationshipTypeIndexCursor relationshipTypeIndexCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipTypeIndexCursor);
            return relationshipTypeIndexCursor;
        }
        finally {
            this.fullAccessRelationshipTypeIndexCursor = null;
        }
    }

    private void acceptFullAccess(InternalRelationshipTypeIndexCursor cursor) {
        if (this.fullAccessRelationshipTypeIndexCursor != null) {
            this.fullAccessRelationshipTypeIndexCursor.release();
        }
        this.fullAccessRelationshipTypeIndexCursor = cursor;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
        }
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        if (this.fullAccessNodeValueIndexCursor != null) {
            this.fullAccessNodeValueIndexCursor.release();
        }
        if (this.fullAccessRelationshipValueIndexCursor != null) {
            this.fullAccessRelationshipValueIndexCursor.release();
        }
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        if (this.relationshipValueIndexCursor != null) {
            this.relationshipValueIndexCursor.release();
        }
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        if (this.fullAccessRelationshipTypeIndexCursor != null) {
            this.fullAccessRelationshipTypeIndexCursor.release();
        }
        this.nodeCursor = null;
        this.fullAccessNodeCursor = null;
        this.relationshipScanCursor = null;
        this.fullAccessRelationshipScanCursor = null;
        this.relationshipTraversalCursor = null;
        this.fullAccessRelationshipTraversalCursor = null;
        this.propertyCursor = null;
        this.fullAccessPropertyCursor = null;
        this.nodeValueIndexCursor = null;
        this.fullAccessNodeValueIndexCursor = null;
        this.nodeLabelIndexCursor = null;
        this.fullAccessNodeLabelIndexCursor = null;
        this.relationshipValueIndexCursor = null;
        this.relationshipTypeIndexCursor = null;
        this.fullAccessRelationshipTypeIndexCursor = null;
        this.fullAccessRelationshipValueIndexCursor = null;
    }

    private InternalCursorFactory newInternalCursors(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return new InternalCursorFactory(this.storageReader, this.storeCursors, cursorContext, memoryTracker);
    }
}

