/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.graphdb.Resource;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.TokenIndexIdLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;

public class TokenScanValueIndexProgressor
implements IndexProgressor,
Resource {
    private final Seeker<TokenScanKey, TokenScanValue> cursor;
    private long baseEntityId;
    private long bits;
    private int prevToken = -1;
    private long prevRange = -1L;
    private boolean closed;
    private final IndexProgressor.EntityTokenClient client;
    private final IndexOrder indexOrder;
    private final EntityRange range;
    private final TokenIndexIdLayout idLayout;
    private int tokenId;

    TokenScanValueIndexProgressor(Seeker<TokenScanKey, TokenScanValue> cursor, IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, EntityRange range, TokenIndexIdLayout idLayout) {
        this.cursor = cursor;
        this.client = client;
        this.indexOrder = indexOrder;
        this.range = range;
        this.idLayout = idLayout;
    }

    public boolean next() {
        while (true) {
            if (this.bits != 0L) {
                long idForClient;
                if (this.indexOrder != IndexOrder.DESCENDING) {
                    delta = Long.numberOfTrailingZeros(this.bits);
                    this.bits &= this.bits - 1L;
                    idForClient = this.baseEntityId + (long)delta;
                } else {
                    delta = Long.numberOfLeadingZeros(this.bits);
                    long bitToZero = 1L << 64 - delta - 1;
                    this.bits &= bitToZero ^ 0xFFFFFFFFFFFFFFFFL;
                    idForClient = this.baseEntityId + 64L - (long)delta - 1L;
                }
                if (!this.isInRange(idForClient) || !this.client.acceptEntity(idForClient, this.tokenId)) continue;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            TokenScanKey key = (TokenScanKey)this.cursor.key();
            this.baseEntityId = this.idLayout.firstIdOfRange(key.idRange);
            this.tokenId = key.tokenId;
            this.bits = ((TokenScanValue)this.cursor.value()).bits;
            if (!$assertionsDisabled && !this.keysInOrder(key, this.indexOrder)) break;
        }
        throw new AssertionError();
    }

    private boolean isInRange(long entityId) {
        return entityId >= this.range.fromInclusive() && entityId < this.range.toExclusive();
    }

    private boolean keysInOrder(TokenScanKey key, IndexOrder order) {
        if (order == IndexOrder.NONE) {
            return true;
        }
        if (this.prevToken != -1 && this.prevRange != -1L && order == IndexOrder.ASCENDING) {
            assert (key.tokenId >= this.prevToken) : "Expected to get ascending ordered results, got " + key + " where previous token was " + this.prevToken;
            assert (key.idRange > this.prevRange) : "Expected to get ascending ordered results, got " + key + " where previous range was " + this.prevRange;
        } else if (this.prevToken != -1 && this.prevRange != -1L && order == IndexOrder.DESCENDING) {
            assert (key.tokenId <= this.prevToken) : "Expected to get descending ordered results, got " + key + " where previous token was " + this.prevToken;
            assert (key.idRange < this.prevRange) : "Expected to get descending ordered results, got " + key + " where previous range was " + this.prevRange;
        }
        this.prevToken = key.tokenId;
        this.prevRange = key.idRange;
        return true;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.cursor.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

