/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.PointKeyUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class PointKey
extends NativeIndexKey<PointKey> {
    private static final long[] NO_COORDINATE = ArrayUtils.EMPTY_LONG_ARRAY;
    private final IndexSpecificSpaceFillingCurveSettings settings;
    private int crsTableId;
    private int crsCode;
    private long derivedSpaceFillingCurveValue;
    private long[] coordinate;
    private NativeIndexKey.Inclusion inclusion;

    PointKey(IndexSpecificSpaceFillingCurveSettings settings) {
        this.settings = settings;
    }

    @Override
    void writeValue(int stateSlot, Value value, NativeIndexKey.Inclusion inclusion) {
        PointValue pointValue = (PointValue)value;
        CoordinateReferenceSystem crs = pointValue.getCoordinateReferenceSystem();
        this.crsCode = crs.getCode();
        this.crsTableId = crs.getTable().getTableId();
        double[] doubleCoordinate = pointValue.coordinate();
        SpaceFillingCurve spaceFillingCurve = this.settings.forCrs(this.crsTableId, this.crsCode);
        this.derivedSpaceFillingCurveValue = spaceFillingCurve.derivedValueFor(doubleCoordinate);
        this.coordinate = new long[doubleCoordinate.length];
        for (int i = 0; i < doubleCoordinate.length; ++i) {
            this.coordinate[i] = Double.doubleToLongBits(doubleCoordinate[i]);
        }
        this.inclusion = inclusion;
    }

    void writePointDerived(CoordinateReferenceSystem crs, long derivedSpaceFillingCurveValue, NativeIndexKey.Inclusion inclusion) {
        this.crsCode = crs.getCode();
        this.crsTableId = crs.getTable().getTableId();
        this.derivedSpaceFillingCurveValue = derivedSpaceFillingCurveValue;
        this.coordinate = NO_COORDINATE;
        this.inclusion = inclusion;
    }

    @Override
    void assertValidValue(int stateSlot, Value value) {
        if (!(value instanceof PointValue)) {
            throw new IllegalArgumentException("Unsupported value type: " + value);
        }
    }

    @Override
    Value[] asValues() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)this.crsTableId, (int)this.crsCode);
        double[] doubleCoordinate = new double[this.coordinate.length];
        for (int i = 0; i < this.coordinate.length; ++i) {
            doubleCoordinate[i] = Double.longBitsToDouble(this.coordinate[i]);
        }
        return new Value[]{Values.pointValue((CoordinateReferenceSystem)crs, (double[])doubleCoordinate)};
    }

    @Override
    void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.crsTableId = Integer.MIN_VALUE;
        this.crsCode = 0;
        this.derivedSpaceFillingCurveValue = 0L;
        this.coordinate = NO_COORDINATE;
        this.inclusion = NativeIndexKey.Inclusion.LOW;
    }

    @Override
    void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.crsTableId = Integer.MAX_VALUE;
        this.crsCode = 0;
        this.derivedSpaceFillingCurveValue = 0L;
        this.coordinate = NO_COORDINATE;
        this.inclusion = NativeIndexKey.Inclusion.HIGH;
    }

    @Override
    int numberOfStateSlots() {
        return 1;
    }

    @Override
    int compareValueTo(PointKey other) {
        int tableIdComparison = Integer.compare(this.crsTableId, other.crsTableId);
        if (tableIdComparison != 0) {
            return tableIdComparison;
        }
        int codeComparison = Integer.compare(this.crsCode, other.crsCode);
        if (codeComparison != 0) {
            return codeComparison;
        }
        int derivedSpaceFillingCurveValueComparison = Long.compare(this.derivedSpaceFillingCurveValue, other.derivedSpaceFillingCurveValue);
        if (derivedSpaceFillingCurveValueComparison != 0) {
            return derivedSpaceFillingCurveValueComparison;
        }
        int dimensions = Math.min(this.coordinate.length, other.coordinate.length);
        for (int i = 0; i < dimensions; ++i) {
            int coordinateComparison = Long.compare(this.coordinate[i], other.coordinate[i]);
            if (coordinateComparison == 0) continue;
            return coordinateComparison;
        }
        return this.inclusion.compareTo(other.inclusion);
    }

    void copyFrom(PointKey from) {
        this.setEntityId(from.getEntityId());
        this.setCompareId(from.getCompareId());
        this.inclusion = from.inclusion;
        this.crsTableId = from.crsTableId;
        this.crsCode = from.crsCode;
        this.derivedSpaceFillingCurveValue = from.derivedSpaceFillingCurveValue;
        this.coordinate = new long[from.coordinate.length];
        System.arraycopy(from.coordinate, 0, this.coordinate, 0, from.coordinate.length);
    }

    int size() {
        int coordinatesSize = 8 * this.coordinate.length;
        return 19 + coordinatesSize;
    }

    void writeToCursor(PageCursor cursor) {
        cursor.putLong(this.getEntityId());
        this.writePointMetadataToCursor(cursor);
        this.writePointValueToCursor(cursor);
    }

    private void writePointMetadataToCursor(PageCursor cursor) {
        PointKeyUtil.writeHeader(cursor, this.crsTableId, this.crsCode, this.coordinate.length);
    }

    private void writePointValueToCursor(PageCursor cursor) {
        cursor.putLong(this.derivedSpaceFillingCurveValue);
        for (int i = 0; i < this.coordinate.length; ++i) {
            cursor.putLong(this.coordinate[i]);
        }
    }

    void readFromCursor(PageCursor cursor, int size) {
        this.initialize(cursor.getLong());
        int dimensions = this.readPointMetadataFromCursor(cursor);
        this.coordinate = new long[dimensions];
        this.readPointValueFromCursor(cursor);
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        if (this.size() != size) {
            cursor.setCursorException("Failed to read PointKey, because the expected size does not correspond to the stored key");
        }
    }

    private int readPointMetadataFromCursor(PageCursor cursor) {
        int header = PointKeyUtil.readHeader(cursor);
        this.crsTableId = PointKeyUtil.crsTableId(header);
        this.crsCode = PointKeyUtil.crsCode(header);
        return PointKeyUtil.dimensions(header);
    }

    private void readPointValueFromCursor(PageCursor cursor) {
        this.derivedSpaceFillingCurveValue = cursor.getLong();
        for (int i = 0; i < this.coordinate.length; ++i) {
            this.coordinate[i] = cursor.getLong();
        }
    }

    public String toString() {
        return "[" + this.asValues()[0].toString() + "],entityId=" + this.getEntityId();
    }
}

