/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.txid;

import java.util.Objects;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.storageengine.api.TransactionIdStore;

public class IdStoreTransactionIdGenerator
implements TransactionIdGenerator {
    private final TransactionIdStore idStore;

    public IdStoreTransactionIdGenerator(TransactionIdStore idStore) {
        this.idStore = Objects.requireNonNull(idStore);
    }

    @Override
    public long nextId(long externalId) {
        long txId = this.idStore.nextCommittingTransactionId();
        if (externalId != 0L) {
            this.validate(txId, externalId);
        }
        return txId;
    }

    private void validate(long transactionId, long expectedTxId) {
        if (transactionId != expectedTxId) {
            throw new IllegalStateException("Received commands batch with txId:" + expectedTxId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
        }
    }
}

