/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionStamp;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.lock.ActiveLock;
import org.neo4j.time.SystemNanoClock;

class KernelTransactionImplementationHandle
implements KernelTransactionHandle {
    private static final String USER_TRANSACTION_NAME_SEPARATOR = "-transaction-";
    private final long startTime;
    private final long startTimeNanos;
    private final TransactionTimeout timeout;
    private final KernelTransactionImplementation tx;
    private final SystemNanoClock clock;
    private final ClientConnectionInfo clientInfo;
    private final AuthSubject subject;
    private final Optional<TerminationMark> terminationMark;
    private final Optional<ExecutingQuery> executingQuery;
    private final Map<String, Object> metaData;
    private final String statusDetails;
    private final long transactionSequenceNumber;
    private final TransactionInitializationTrace initializationTrace;
    private final KernelTransactionStamp transactionStamp;
    private final String databaseName;
    private final long lastClosedTxId;
    private final long transactionHorizon;

    KernelTransactionImplementationHandle(KernelTransactionImplementation tx, SystemNanoClock clock, CursorContext cursorContext) {
        this.transactionStamp = new KernelTransactionStamp(tx);
        this.startTime = tx.startTime();
        this.startTimeNanos = tx.startTimeNanos();
        this.timeout = tx.timeout();
        this.subject = tx.subjectOrAnonymous();
        this.terminationMark = tx.getTerminationMark();
        this.executingQuery = tx.executingQuery();
        this.metaData = tx.getMetaData();
        this.statusDetails = tx.statusDetails();
        this.transactionSequenceNumber = tx.getTransactionSequenceNumber();
        this.initializationTrace = tx.getInitializationTrace();
        this.clientInfo = tx.clientInfo();
        this.databaseName = tx.getDatabaseName();
        VersionContext versionContext = cursorContext.getVersionContext();
        this.lastClosedTxId = versionContext.lastClosedTransactionId();
        this.transactionHorizon = this.transactionHorizon(versionContext);
        this.tx = tx;
        this.clock = clock;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    public TransactionTimeout timeout() {
        return this.timeout;
    }

    @Override
    public boolean isOpen() {
        return this.transactionStamp.isOpen();
    }

    @Override
    public boolean isCommitting() {
        return this.transactionStamp.isCommitting();
    }

    @Override
    public boolean isRollingback() {
        return this.transactionStamp.isRollingback();
    }

    @Override
    public boolean markForTermination(Status reason) {
        return this.tx.markForTermination(this.transactionStamp.getTransactionSequenceNumber(), reason);
    }

    @Override
    public AuthSubject subject() {
        return this.subject;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public String getStatusDetails() {
        return this.statusDetails;
    }

    @Override
    public Optional<TerminationMark> terminationMark() {
        return this.terminationMark;
    }

    @Override
    public boolean isUnderlyingTransaction(KernelTransaction tx) {
        return this.tx == tx;
    }

    @Override
    public long getTransactionSequenceNumber() {
        return this.transactionSequenceNumber;
    }

    @Override
    public String getUserTransactionName() {
        return this.databaseName + USER_TRANSACTION_NAME_SEPARATOR + this.getTransactionSequenceNumber();
    }

    @Override
    public Optional<ExecutingQuery> executingQuery() {
        return this.executingQuery;
    }

    @Override
    public Collection<ActiveLock> activeLocks() {
        return this.tx.activeLocks();
    }

    @Override
    public TransactionExecutionStatistic transactionStatistic() {
        if (this.transactionStamp.isNotExpired()) {
            return new TransactionExecutionStatistic(this.tx, this.clock, this.startTime);
        }
        return TransactionExecutionStatistic.NOT_AVAILABLE;
    }

    @Override
    public TransactionInitializationTrace transactionInitialisationTrace() {
        return this.initializationTrace;
    }

    @Override
    public Optional<ClientConnectionInfo> clientInfo() {
        return Optional.ofNullable(this.clientInfo);
    }

    @Override
    public boolean isSchemaTransaction() {
        return this.tx.isSchemaTransaction();
    }

    @Override
    public long getLastClosedTxId() {
        return this.lastClosedTxId;
    }

    @Override
    public long getTransactionHorizon() {
        return this.transactionHorizon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionImplementationHandle that = (KernelTransactionImplementationHandle)o;
        return this.transactionStamp.equals(that.transactionStamp);
    }

    public int hashCode() {
        return this.transactionStamp.hashCode();
    }

    public String toString() {
        return "KernelTransactionImplementationHandle{transactionSequenceNumber=" + this.transactionStamp.getTransactionSequenceNumber() + ", tx=" + this.tx + "}";
    }

    private long transactionHorizon(VersionContext versionContext) {
        long oldestVisibleTransactionNumber = versionContext.oldestVisibleTransactionNumber();
        if (oldestVisibleTransactionNumber > 1L) {
            return oldestVisibleTransactionNumber;
        }
        return versionContext.lastClosedTransactionId();
    }
}

