/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;

class InnerTransactionHandlerImpl
implements InnerTransactionHandler {
    private boolean closed;
    private Status terminationReason;
    private MutableLongSet innerTransactionIds;
    private final KernelTransactions kernelTransactions;

    InnerTransactionHandlerImpl(KernelTransactions kernelTransactions) {
        this.kernelTransactions = kernelTransactions;
    }

    public synchronized void registerInnerTransaction(long innerTransactionId) {
        if (this.closed) {
            throw new IllegalStateException("The inner transaction handler is already closed.");
        }
        if (this.terminationReason != null) {
            this.terminateInnerTransaction(this.terminationReason, this.getTransactionHandlesById(), innerTransactionId);
        } else {
            if (this.innerTransactionIds == null) {
                this.innerTransactionIds = LongSets.mutable.empty();
            }
            this.innerTransactionIds.add(innerTransactionId);
        }
    }

    public synchronized void removeInnerTransaction(long innerTransactionId) {
        if (this.innerTransactionIds != null) {
            this.innerTransactionIds.remove(innerTransactionId);
        }
    }

    synchronized boolean hasInnerTransaction() {
        return this.innerTransactionIds != null && !this.innerTransactionIds.isEmpty();
    }

    synchronized void terminateInnerTransactions(Status reason) {
        this.terminationReason = reason;
        ImmutableLongObjectMap<KernelTransactionHandle> handlesById = this.getTransactionHandlesById();
        if (this.innerTransactionIds != null) {
            this.innerTransactionIds.forEach((LongProcedure & Serializable)innerTransactionId -> this.terminateInnerTransaction(reason, handlesById, innerTransactionId));
            this.innerTransactionIds.clear();
            this.innerTransactionIds = null;
        }
    }

    private ImmutableLongObjectMap<KernelTransactionHandle> getTransactionHandlesById() {
        return LongObjectMaps.immutable.from(this.kernelTransactions.executingTransactions(), KernelTransactionHandle::getTransactionSequenceNumber, (Function & Serializable)a -> a);
    }

    private void terminateInnerTransaction(Status reason, ImmutableLongObjectMap<KernelTransactionHandle> handlesById, long innerTransactionId) {
        KernelTransactionHandle kernelTransactionHandle = (KernelTransactionHandle)handlesById.get(innerTransactionId);
        if (kernelTransactionHandle != null) {
            kernelTransactionHandle.markForTermination(reason);
        }
    }

    synchronized void close() {
        this.closed = true;
        if (this.innerTransactionIds != null) {
            this.innerTransactionIds.clear();
        }
        this.innerTransactionIds = null;
    }
}

