/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.nio.file.OpenOption;
import java.time.Clock;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingControllerFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ReadableStorageEngine;

public final class IndexingServiceFactory {
    private IndexingServiceFactory() {
    }

    public static IndexingService createIndexingService(ReadableStorageEngine storageEngine, Config config, JobScheduler scheduler, IndexProviderMap providerMap, IndexStoreViewFactory indexStoreViewFactory, TokenNameLookup tokenNameLookup, Iterable<IndexDescriptor> indexRules, InternalLogProvider internalLogProvider, IndexMonitor monitor, SchemaState schemaState, IndexStatisticsStore indexStatisticsStore, CursorContextFactory contextFactory, MemoryTracker memoryTracker, String databaseName, DatabaseReadOnlyChecker readOnlyChecker, Clock clock, KernelVersionProvider kernelVersionProvider, FileSystemAbstraction fs, TransactionVisibilityProvider transactionVisibilityProvider) {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
        IndexMapReference indexMapRef = new IndexMapReference();
        IndexSamplingControllerFactory factory = new IndexSamplingControllerFactory(samplingConfig, indexStatisticsStore, scheduler, tokenNameLookup, internalLogProvider, contextFactory, config, databaseName);
        IndexSamplingController indexSamplingController = factory.create(indexMapRef);
        IndexProxyCreator proxySetup = new IndexProxyCreator(samplingConfig, indexStatisticsStore, providerMap, tokenNameLookup, internalLogProvider, (ImmutableSet<OpenOption>)storageEngine.getOpenOptions(), clock, storageEngine.indexingBehaviour());
        return new IndexingService(storageEngine, proxySetup, providerMap, indexMapRef, indexStoreViewFactory, indexRules, indexSamplingController, tokenNameLookup, scheduler, schemaState, internalLogProvider, monitor, indexStatisticsStore, contextFactory, memoryTracker, databaseName, readOnlyChecker, config, kernelVersionProvider, fs, transactionVisibilityProvider);
    }
}

